/**
 * # CHAPTER #
 * ============================================================================
 * 分類条件関連のヘッダーファイル
 * ============================================================================
 */

#ifndef _CONDITION_H
#define _CONDITION_H

#include <readData.h>

/**
 * # STRUCT #
 * 分類条件別クラス別件数の構造体
 * +---------+-------+-------+---+-------+------+
 * |condition| cls0  | cls1  |...| clsN  | Total|
 * +---------+-------+-------+---+-------+------+
 * |    match|mCnt[0]|mCnt[1]|   |mCnt[N]| mtCnt|
 * +---------+-------+-------+---+-------+------+
 * |  unmatch|uCnt[0]|uCnt[1]|   |uCnt[N]| utCnt|
 * +---------+-------+-------+---+-------+------+
 * |     NULL|nCnt[0]|nCnt[1]|   |nCnt[N]|      |
 * +---------+-------+-------+---+-------+------+
 * |    Total|tCnt[0]|tCnt[1]|   |tCnt[N]| total|
 * |         |tShr[0]|tShr[1]|   |tShr[N]|      |
 * +---------+-------+-------+---+-------+------+
 *
 * +---------+-------+-------+---+-------+------+
 * |condition| cls0  | cls1  |...| clsN  | Total|
 * +---------+-------+-------+---+-------+------+
 * |    match|mmCnt[0]|mmCnt[1]|   |mmCnt[N]| mtCnt|
 * |         |mShr[0]|mShr[1]|   |mShr[N]| mtShr|
 * +---------+-------+-------+---+-------+------+
 * |  unmatch|uCnt[0]|uCnt[1]|   |uCnt[N]| utCnt|
 * |         |uShr[0]|uShr[1]|   |uShr[N]| utShr|
 * +---------+-------+-------+---+-------+------+
 * |     NULL|nCnt[0]|nCnt[1]|   |nCnt[N]|      |
 * +---------+-------+-------+---+-------+------+
 * |    Total|tCnt[0]|tCnt[1]|   |tCnt[N]| total|
 * |         |tShr[0]|tShr[1]|   |tShr[N]|      |
 * +---------+-------+-------+---+-------+------+
 * mShr[i]=mCnt[i]/mtCnt
 * uShr[i]=uCnt[i]/utCnt
 * mtShr=mtCnt/total
 * utShr=utCnt/total
 */
struct CndCnt {
  double uCnt[MaxClsLen]; /*unmatch,クラス別件数*/
  double mCnt[MaxClsLen]; /*match,クラス別件数*/
  double mRatio;          /*NULL値を反映させる前のmCntの割合(uRatio=1-mRatio)*/
  int mCount;             /*matchの実件数(データポインタの件数用)*/
  int uCount;             /*unmatchの実件数(データポインタの件数用)*/
  int nCount;             /*mCount,uCount中、nullデータの数*/
  double nCnt[MaxClsLen]; /*NULL値のクラス別件数*/
  double uuCnt[MaxClsLen]; /*unmatch,クラス別件数(NULL件数考慮)*/
  double mmCnt[MaxClsLen]; /*match,クラス別件数(NULL件数考慮)*/
  double tCnt[MaxClsLen]; /*クラス別件数*/
  double utCnt;           /*unmatch total件数*/
  double utShr;           /*unmatch totalシェア*/
  double mtCnt;           /*match total件数*/
  double mtShr;           /*match totalシェア*/
  double total;           /*トータル件数*/
  int    splitType;       /*spliting criteria(0:Gini,1:Entropy,2:GeoMean)*/
  double splitBefor;      /*value for spilitting criteria before splitting*/
  double splitAfter;      /*value for spilitting criteria after  splitting*/


  /*ユーザ指定のコストファイル*/
  struct Cost *cost;

  /*---------------------------------------------------*/
  /*マッチ、アンマッチ別クラス別シェア                 */
  /*                                                   */
  /* laplace estimateの計算方法                        */
  /*   p(i)=(Ni+1)/(k+N)                               */
  /*   k:クラス数=ClassSize                            */
  /*   Ni: クラスiの件数=cnt->xCnt[]                   */
  /*   N : 総件数                                      */
  /*                                                   */
  /* コストの勘案方法                                  */
  /*   xShrC : 全コスト計に対する各クラスコストの比率  */
  /*   xShrC=C(j)*xShr(j)/SUMi(C(i)*xShr(i))           */
  /*   where C(j)=SUMi(cost(j,i))                      */
  /*   cost(j,i)とはクラスjをiと予測したときのコスト   */
  /*   Pazzani,at el, Reducing Misclassification Costs */
  /*---------------------------------------------------*/

  /*件数シェア+コストなし                            */
  double uShrRN[MaxClsLen];/*unmatch,クラス別シェア*/
  double mShrRN[MaxClsLen];/*match,クラス別シェア*/
  double tShrRN[MaxClsLen];/*クラス別シェア*/

  /*件数シェア+コスト勘案                            */
  double uShrRC[MaxClsLen]; /*unmatch,クラス別シェア*/
  double mShrRC[MaxClsLen]; /*match,クラス別シェア*/
  double tShrRC[MaxClsLen]; /*クラス別シェア*/

  /*--------------------------------------------------------------*/
  /*splitting ruleを計算するときに使う出現確率を指すポインタ      */
  /*  optPrb==0 -> xShrRN                                         */
  /*  optPrb==1 -> xShrRC                                         */
  /*  optPrb==2 -> xShrLN                                         */
  /*  optPrb==3 -> xShrLC                                         */
  /*これらのポインタの初期化はiniCndCnt()にて行う                 */
  /*--------------------------------------------------------------*/
  double *uShr;           /*unmatch,クラス別シェア*/
  double *mShr;           /*match,クラス別シェア*/
  double *tShr;           /*クラス別シェア*/
};

/**
 * # PROTOTYPE #
 */
void	iniCndCnt( struct CndCnt *cnt, struct Cost *cost);
void	prnCndCnt( struct CndCnt *cnt);
void	clearCndCntCel(struct CndCnt *cnt);
void	cpyCndCnt(struct CndCnt *cntTo, struct CndCnt *cntFrom);
void	calCndCntSplit( struct CndCnt *cnt);
void	calCndCnt( struct CndCnt *cnt);
int	dominantClass(struct CndCnt *cnt);
double	calCndCntCost(struct CndCnt *cnt, struct Cost *cost, int class);

#endif
