/**
 * # CHAPTER #
 * ============================================================================
 * BONSAIでパターン候補を調べる際のforbidden list用ハッシュ関連関数
 * ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <musashi/mssBase.h>
#include <usint.h>
#include <exHash.h>

/**
 * # FUNCTION #
 * Hash関数：数値列からHash値の計算
 */
static int EHhash(usint *x){
  int i, hash;
  hash=0;
  for(i=0; i<strlenUSI(x); i++){
    hash=hash+(int)x[i];
  }
  hash=hash%EHbucket;
  return(hash);
}

/**
 * # FUNCTION #
 * ハッシュテーブル(A)に、新しいデータ(x)を追加する。
 * 既に値が存在すればなにもしない。
 */
void EHinsert(usint *x, struct cell **A){
  int k;
  struct cell *p, *q, *r;

  k=EHhash(x);
  q=A[k];
  p=(struct cell *)mssMalloc(sizeof(struct cell),"EHinsert");
  if(q==NULL){
    A[k]=p;
  }else{
    while(q!=NULL){
      if(strcmpUSI(q->name,x)==0){
        return;
      }else{
        r=q;
        q=q->next;
      }
    }
    r->next=p;
  }
  strcpyUSI(p->name,x);
  p->next=NULL;
  return;
}

/**
 * # FUNCTION #
 * ハッシュテーブル(A)から、データ(x)を削除する。
 * 既に値が存在すればなにもしない。
 */
void EHdelete(usint *x, struct cell **A){
  int k;
  struct cell *q, *r;
  k=EHhash(x);
  q=A[k];
  r=NULL;
  while(q!=NULL){
    if(strcmpUSI(q->name,x)==0){
      if(r==NULL){
        A[k]=q->next;
      }else{
        r->next=q->next;
      }
      return;
    }
    r=q; q=q->next;
  }
  return;
}

/**
 * # FUNCTION #
 * ハッシュテーブル(A)に、データ(x)が存在すれば1、存在しなければ0を返す。
 */
int EHmember(usint *x, struct cell **A){
  struct cell *q, *r;
  q=A[EHhash(x)];
  while(q!=NULL){
    if(strcmpUSI(q->name,x)==0){
      return(1);
    }
    r=q; q=q->next;
  }
  return(0);
}

/**
 * # FUNCTION #
 * ハッシュテーブル(A)の領域を開放する。
 */
void EHfree(struct cell **A){
  struct cell *q, *next;
  int i;
  for(i=0; i<EHbucket; i++){
    if(*(A+i)==NULL)continue;
    q=*(A+i);
    while(q!=NULL){
      next=q->next;
      mssFree(q);
      q=next;
    }
  }
  return;
}

/**
 * # FUNCTION #
 * ハッシュテーブルを出力する(debug用)
 */
void EHprint(struct cell **A){
  int i;
  struct cell *nx;
  i=0;
  for(i=0; i<EHbucket; i++){
    if(A[i]==NULL) continue;
    printf("%03d ",i);
    prnstrUSI(A[i]->name);
    nx=A[i]->next;
    while(nx != NULL){
      printf("- ");
      prnstrUSI(nx->name);
      nx=nx->next;
    }
    printf("\n");
  }
}
