/**
 * # CHAPTER #
 * ============================================================================
 * BONSAIでパターン候補を調べる際のpriority queue関連ヘッダー
 * ============================================================================
 */

#ifndef _PRIORITYQUEUE_H
#define _PRIORITYQUEUE_H

#include <stdio.h>
#include <stdlib.h>
#include <bonsai.h>

/**
 * # STRUCT #
 * 各キューに保存される正規パターン＆上限値構造体
 */
struct PQkey {
  struct Regexp reg;  /*正規パターン*/
  double upperBound;  /*この正規パターンのエントロピーのupperBound*/
};
  
/**
 * # STRUCT #
 * priority queueのノード
 */
struct PQnode{
  struct PQkey key;
  struct PQnode *parent, *left, *right;
  int    rank;
};

/**
 * # PROTOTYPE #
 */
void           PQptree(struct PQnode *p,int h);
void           PQprintTree(char *s,struct PQnode *pp);
int            PQisExternalNode(struct PQnode *v);
int            PQisEmpty(struct PQnode *v);
struct PQnode *PQmakeNode(void);
struct PQnode *PQworstMember(struct PQnode *v);
void           PQinsert(struct PQkey *key,struct PQnode *v);
void           PQpop(struct Regexp *reg,double *upperBound, struct PQnode *v);
void           PQdeleteNode(struct PQnode *v);
void           PQfree(struct PQnode *v);

#endif
