/**
 * # CHAPTER #
 * ============================================================================
 * xtclassifyで用いられるデータ読み込み関連ヘッダー
 * ============================================================================
 */

#ifndef _READDATA_H
#define _READDATA_H

#include <musashi/mssHeader.h>

#define MaxPatLen 1024 /*パターンの最大文字数*/
#define MaxClsLen 10   /*最大クラス数*/
#define MaxRegLen 10   /*正規パターンのアルファベット最大長*/
#define RegCanCnt 200  /*正規パターン侯補の数(setRegTblで使用)*/

/**
 * # STRUCT #
 * コストの構造体
 * +------------+---------------------------------------+
 * |            | predicted as                          |
 * |            +---------+---------+---------+---------+
 * |            |     cls0|     cls1|     cls2|    Total|
 * +------+-----+---------+---------+---------+---------+
 * |actual|cls0 |tbl[0][0]|tbl[0][1]|tbl[0][2]|actTtl[0]|
 * |      |cls1 |tbl[1][0]|tbl[1][1]|tbl[1][2]|actTtl[1]|
 * |      |cls2 |tbl[2][0]|tbl[2][1]|tbl[2][2]|actTtl[2]|
 * +------+-----+---------+---------+---------+---------+
 * デフォルトactual=predictedは０、その他は１。
 */
struct Cost {
  double tbl[MaxClsLen][MaxClsLen];
  double actTtl[MaxClsLen];
  struct Class *cls;
};

/**
 * # STRUCT #
 * クラス(結果属性)構造体
 * str[0]="Positive", str[1]="Negative"
 * chr = "0011111010101011010010000...."
 * cnt = 2
 */
struct Class {
  char *str[MaxClsLen]; /*データ上のクラスの文字列*/
  int   cnt;            /*クラスの数(ClassSizeに等しい)*/
  char *chr;            /*実データ(str[]の配列番号として)*/
};

/**
 * # STRUCT #
 * 一つのパターン項目を表す構造体
 */
struct Pattern {
  struct Map    *map;        /*アルファベット-インデックス*/
  struct StrListUSI *patAlp; /*アルファベットによるパターン*/
  struct StrListUSI *patIdx; /*インデックスによるパターン*/
  struct RegTbl *regTbl;     /*候補となる正規表現リスト*/
  char  *att[RegCanCnt];     /*上記正規表現毎に1:match,0:unmatchのデータが入る*/
  int    attCnt;             /*att[]の属性(正規表現)の数*/
  int    numPat;             /*0:文字パターン,1:数値パターン*/
};

/**
 * # STRUCT #
 * 一つのカテゴリー項目を表す構造体
 */
struct Category {
  struct mssHash *name; /*属性値-内部処理用数値のhash表*/
  char  **valName;   /*内部処理用数値-属性値の配列*/
  int    cnt;        /*属性値の種類数*/
  int   *val;        /*数値に変換された全行の値が入る*/
};

/**
 * # STRUCT #
 * データの構造体
 */
struct Data {
  struct Pattern  *pat;     /*パターン属性*/
  char           **patNull; /*パターン属性がNULLかどうか*/
  int              patCnt;  /*パターン属性の数*/
  
  double         **num;     /*数値属性*/
  char           **numNull; /*数値属性がNULLかどうか*/
  int              numCnt;  /*数値属性の数*/
  
  struct Category *cat;     /*カテゴリー属性*/
  char           **catNull; /*カテゴリー属性がNULLかどうか*/
  int              catCnt;  /*カテゴリー属性の数*/
  
  struct Class    *cls;     /*結果属性*/
  int              cnt;     /*データの総件数*/
  
  struct mssFPR    *fpr;    /*ファイル読み込みポインタ*/
};

/**
 * # PROTOTYPE # 
 */
int			countDat(struct mssFPR *fpr);
struct Class *		setClass(struct mssFPR *trn, struct mssFPR *tst, struct mssHeader *hd);
void			freeClass(struct Class *cls);
struct Cost *		readCost(char *fname,struct Class *cls);
void			showCost(struct Cost *cost, struct mssFPW *fpw);
struct Map **		setMapAlp(struct mssFPR *trn,struct mssFPR *tst, struct mssHeader *hd);
void			freeMap(struct Map **map);
struct Category *	setCatHash(struct mssFPR *trn,struct mssFPR *tst,struct mssHeader *hd);
struct Data *		setDat(struct mssFPR *trn,struct mssHeader *hd,struct Class *cls,int cnt, struct Map **map, struct Category *cat);
void			freeDat(struct Data *dat);
void			showDat( struct Data *dat);

#endif
