/**
 * # CHAPTER #
 * ============================================================================
 * xtclassifyで用いられる決定木関連ヘッダー
 * ============================================================================
 */

#ifndef _TREE_H
#define _TREE_H

#include <condition.h>
#include <classTable.h>

/**
 * # STRUCT #
 *ツリーのノード構造体
 */
struct Node {
  int            nodeType;  /*0:Leaf, 1:Node*/
  int            pruned;    /*0:not, 1:pruned leaf*/
  struct Node   *parent;    /*親nodeへのポインタ*/
  struct Node   *uNode;     /*unmatch nodeへのポインタ*/
  struct Node   *mNode;     /*match nodeへのポインタ*/
  struct CndCnt  trnCnt;    /*条件別match,unmatch件数集計*/
  int            attType;   /*このnodeで使った属性タイプ(pat:0 num:1 cat:2)*/
  int            attFldNo;  /*このnodeで使った属性の項目番号(それぞれ0から)*/
  int            attPatNo;  /*このnodeで使ったpat属性番号(それぞれの属性での)*/
                            /*上記3つで利用属性が決まる*/
  double         numTH;     /*数値の場合の閾値*/
  char          *catList;   /*カテゴリーの場合のカテゴリー値リスト*/
  int            level;     /*ツリーの深さ*/
  int            cls;       /*このnodeにおける最大件数をもつClass値*/
  int            mulCls;    /*最大件数をもつClassが複数あるかどうかフラッグ*/

  double         estErrNode;/*このノードのエラー数*/
  double         estErrLeaf;/*このノード以下のエラー数*/

  double         costNode;  /*このノードのコスト*/
  double         costLeaf;  /*このノード以下のコスト*/
};

/**
 * # STRUCT #
 *ツリー全体の構造体
 */
struct Tree {
  struct Node    *topNode;   /*ツリーのトップノード*/
  struct Data    *dat;       /*木を生成した時のデータ(実データ以外)*/
  struct ClsTbl  *trnRsl;    /*トレーニングデータにおける結果*/
  struct ClsTbl  *tstRsl;    /*テストデータにおける結果*/
  int             leafCnt;   /*Leafの数*/
  int             deepest;   /*最深レベル*/
};

/**
 * # PROTOTYPE #
 */
struct Tree *decisionTree(struct Data *trn,struct Data *tst,struct Cost *cost);
struct Tree *updateTree( struct Tree *tree, struct Tree *betterTree);
void showTree(struct Tree *tree,struct Cost *cost, struct mssFPW *fpw);
void showTreePMML(struct Tree *tree,struct Cost *cost, struct mssFPW *fpw);
void freeTree(struct Tree *tree);
void showProgressTree(struct Data *dat, struct Tree *tree);

#endif
