/**
 * # CHAPTER #
 * ============================================================================
 * unsigned intによる文字列を扱う関数
 * alphabet,indexは内部的にunsigned intで表現されている。
 * 0は終端記号
 * ============================================================================
 */
#include <musashi.h>
#include <usint.h>
#include <stdio.h>

/**
 * # FUNCTION #
 * 文字列としてのusint配列を書き出す(デバッグ用)
 */
void prnstrUSI(usint *str)
{
  while(*str!=0) printf("%d ",*str++);
}

/**
 * # FUNCTION #
 * strcpyと同じ機能を持つusint文字列版
 */
void strcpyUSI(usint *to, usint *from){
  while(*from!=0) *(to++)=*(from++);
  *to=*from;
}

/**
 * # FUNCTION #
 * strlenと同じ機能を持つusint文字列版
 * ANSI C/C++辞典p.618
 */
int strlenUSI(usint *dat){
  int i=0;
  for(i=0;dat[i];i++);
  return(i);
}

/**
 * # FUNCTION #
 * strchrと同じ機能を持つusint文字列版
 * ANSI C/C++辞典p.609
 */
usint *strchrUSI(usint *s, usint c){
  while(*s!=c){
    if(*s==0)return(NULL);
    s++;
  }
  return(s);
}

/**
 * # FUNCTION #
 * strstrと同じ機能を持つusint文字列版
 * ANSI C/C++辞典p.625
 */
usint *strstrUSI(usint *s1,usint *s2){

  if(*s2==0) return(s1);
  for(;(s1=strchrUSI(s1,*s2))!=NULL;s1++){
    usint *ss1=s1;
    usint *ss2=s2;
    do{
      ss2++;
      if(*ss2==0) return(s1);
      ss1++;
    }while(*ss1==*ss2);
  }
  return(NULL);
}

/**
 * # FUNCTION #
 * strcmpと同じ機能を持つusint文字列版
 * ANSI C/C++辞典p.620
 */
int strcmpUSI(usint *s1,usint *s2){

  while(*s1==*s2){
    if(*s1==0)return(0);
    s1++; s2++;
  }
  return(*s1-*s2);
}

/**
 * # FUNCTION #
 * strncmpと同じ機能を持つusint文字列版
 * ANSI C/C++辞典p.620
 */
int strncmpUSI(usint *s1,usint *s2,int n){

  while(n && *s1 && *s2){
    int d=*s1-*s2;
    if(d) return(d);
    s1++; s2++; n--;
  }
  if(!n ) return( 0);
  if(*s1) return( 1);
  else    return(-1);
}

/**
 * # FUNCTION #
 * mssInitStrList(複数の文字列管理)のusint文字列版
 * 複数の文字列管理
 */
struct StrListUSI *initStrListUSI(){
  struct StrListUSI *st;
  st=mssMalloc(sizeof(struct StrListUSI),"initStrListUIS");
  st->top       =NULL;
  st->pointer   =NULL;
  st->lineCnt   =0;
  st->size      =0;
  return(st);
}

/**
 * # FUNCTION #
 * mssFreeStrListのusint文字列版
 */
void freeStrListUSI(struct StrListUSI *st){
  if(st==NULL)return;
  mssFree(st->top);
  mssFree(st->pointer);
  mssFree(st);
}

/**
 * # FUNCTION #
 * mssPutStrListのusint文字列版
 * 文字列リスト領域に文字列を登録する
 */
void putStrListUSI(struct StrListUSI *st, usint *str){
  int i;
  int len;
  usint *ptr;

  /*文字列サイズのカウント*/
  len=strlenUSI(str);

  /*文字列格納領域確保*/
  st->top=mssRealloc(st->top,sizeof(usint)*(st->size+len+1),"putStrListUSI");
  ptr=st->top+st->size;

  /*文字列の格納*/
  for(i=0; i<len; i++){
    *ptr=*(str+i); ptr++;
  }
  *ptr=0;

  /*ポインタを登録*/
  st->pointer=mssRealloc(st->pointer,sizeof(int)*(st->lineCnt+1),"putStrListUSI");
  *(st->pointer+st->lineCnt)=st->size;

  /*行数、サイズのカウントアップ*/
  st->lineCnt++;
  st->size += len+1; /*ターミネータ(０)分＋１*/
}

/**
 * # FUNCTION #
 * mssGetStrListのusint文字列版
 * 文字列リスト領域からn番目のint列を返す
 */
usint *getStrListUSI(struct StrListUSI *st,int n){
  return( st->top+*(st->pointer+n) );
}
