/**
 * # CHAPTER #
 * ============================================================================
 * unsigned intによる文字列を扱うヘッダー
 * ============================================================================
 */

#ifndef _USINT_H
#define _USINT_H

/**
 * # TYPEDEF #
 */
typedef unsigned short int usint;

/**
 * # STRUCT #
 * 数値列をリストとして登録する構造体
 * 登録されたn番目の文字列へのポインタによるアクセスが可能
 * 行(line)、要素(element):0はターミネータ
 * 1,2,3,0
 * 3,5,0
 * 6,1,2,3,0
 * top=先頭行の先頭要素のアドレス
 * pointer={0,4,7}
 * lineCnt=3
 * size=9
 */
struct StrListUSI {
  usint *top;     /*intリストの先頭*/
  int   *pointer; /*int列の相対的位置(先頭からの要素数)が入る*/
  int    lineCnt; /*登録されたint列数*/
  int    size;    /*登録されたint要素の総数*/
}; 

/**
 * # PROTOTYPE #
 */
void			prnstrUSI(usint *str);
void			strcpyUSI(usint *to, usint *from);
int			strlenUSI(usint *dat);
usint *			strchrUSI(usint *s, usint c);
usint *			strstrUSI(usint *s1,usint *s2);
int			strncmpUSI(usint *s1,usint *s2,int n);
int			strcmpUSI(usint *s1,usint *s2);
struct StrListUSI *	initStrListUSI();
void			freeStrListUSI(struct StrListUSI *st);
void			putStrListUSI(struct StrListUSI *st, usint *str);
usint *			getStrListUSI(struct StrListUSI *st,int n);

#endif
