/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIに対応 2003/07/19                                           */
/* 1.1 : パラメータの整理,PMML対応 2003/08/29                                 */
/* 1.2 : NULL値対応 2003/09/08                                                */
/* 1.3 : カテゴリー属性の分類でmCountの計算方法のバグ修正 2003/10/16          */
/* 1.4 : ConfusionMatrixの集計方法をNull値対応に合わせて修正 2003/10/30       */
/* 1.5 : ノードのsplitting属性が全てNULL時のエラー修正 2003/11/10             */
/* 1.6 : 出力ミス(By cost)の修正 2003/11/20                                   */
/* 1.7 : 数値のソートminor bug fix 2004/02/09                                 */
/*============================================================================*/
#include <musashi.h>
#include <xtclassifyHelp.h>
#include <classTable.h>
#include <bonsai.h>
#include <usint.h>
#include <readData.h>
#include <tree.h>
#include <condition.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

struct mssComHelp comHelp={
  "xtclassify",   /* コマンド名       */
  "1.7",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int ClassSize;

/*----------------------------------------------------------------------------*/
/* パターン項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optPAT={
    OFLD,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n",    /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    PATT,   /* このオプションのタイトル(Helpで表示)                         */
    PATC,   /* このオプションのコメント(Helpで表示)                         */
    PATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 数値項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optNUM={
    OFLD,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    NUMT,   /* このオプションのタイトル(Helpで表示)                         */
    NUMC,   /* このオプションのコメント(Helpで表示)                         */
    NUMF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* カテゴリ項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCAT={
    OFLD,   /* オプションタイプ                                             */
    "d",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    CATT,   /* このオプションのタイトル(Helpで表示)                         */
    CATC,   /* このオプションのコメント(Helpで表示)                         */
    CATF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 結果属性項目                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optCLS={
    OFLD,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    CLST,   /* このオプションのタイトル(Helpで表示)                         */
    CLSC,   /* このオプションのコメント(Helpで表示)                         */
    CLSF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* トレーニングファイル                                                       */
/*----------------------------------------------------------------------------*/
  MssOptINF optTRN={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    TRNT,   /* このオプションのタイトル(Helpで表示)                         */
    TRNC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* テストファイル                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optTST={
    OINF,   /* オプションタイプ                                             */
    "I",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    TSTT,   /* このオプションのタイトル(Helpで表示)                         */
    TSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* テキストによる結果出力ファイル                                             */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* PMMLによる結果出力ファイル                                                 */
/*----------------------------------------------------------------------------*/
  MssOptOTF optPML={
    OOTF,   /* オプションタイプ                                             */
    "P",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    PMLT,   /* このオプションのタイトル(Helpで表示)                         */
    PMLC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* デリミター                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDLM={
    OSTR,   /* オプションタイプ                                             */
    "D",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "",     /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    1,      /* 文字列の最大長                                               */
    DLMT,   /* このオプションのタイトル(Helpで表示)                         */
    DLMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* コストファイル                                                             */
/*----------------------------------------------------------------------------*/
  MssOptINF optCST={
    OINF,   /* オプションタイプ                                             */
    "C",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    CSTT,   /* このオプションのタイトル(Helpで表示)                         */
    CSTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* モデルの種類                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSEL optMDL={
    OSEL,   /* オプションタイプ                                             */
    "m",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "0",    /* デフォルト(文字列にて)                                       */
    "0",    /* 指定可能な値リスト                                           */
    MDLT,   /* このオプションのタイトル(Helpで表示)                         */
    MDLC,   /* このオプションのコメント(Helpで表示)                         */
    MDLF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* サブシーケンス                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 終端一致                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optEND={
    OINT,   /* オプションタイプ                                             */
    "E",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    9,      /* 最大値                                                       */
    ENDT,   /* このオプションのタイトル(Helpで表示)                         */
    ENDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 先頭一致                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optBGN={
    OINT,   /* オプションタイプ                                             */
    "B",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    10,     /* 最大値                                                       */
    BGNT,   /* このオプションのタイトル(Helpで表示)                         */
    BGNC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* サイズ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optSIZ={
    OINT,   /* オプションタイプ                                             */
    "s",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    2,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    10,     /* 最大値                                                       */
    SIZT,   /* このオプションのタイトル(Helpで表示)                         */
    SIZC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 乱数の種                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optSED={
    OINT,   /* オプションタイプ                                             */
    "S",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    -1,     /* デフォルト(数値として指定)                                   */
    -1,     /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    SEDT,   /* このオプションのタイトル(Helpで表示)                         */
    SEDC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 候補正規パターン数                                                         */
/*----------------------------------------------------------------------------*/
  MssOptINT optCAN={
    OINT,   /* オプションタイプ                                             */
    "L",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    30,     /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    256,    /* 最大値                                                       */
    CANT,   /* このオプションのタイトル(Helpで表示)                         */
    CANC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ローカルサーチマルチスタート回数                                           */
/*----------------------------------------------------------------------------*/
  MssOptINT optTRY={
    OINT,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    5,      /* 最大値                                                       */
    TRYT,   /* このオプションのタイトル(Helpで表示)                         */
    TRYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 信頼度                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptDBL optCNF={
    ODBL,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    25,     /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    100,    /* 最大値                                                       */
    CNFT,   /* このオプションのタイトル(Helpで表示)                         */
    CNFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ノードに含む最小ケース数                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optMIN={
    OINT,   /* オプションタイプ                                             */
    "M",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    MINT,   /* このオプションのタイトル(Helpで表示)                         */
    MINC    /* このオプションのコメント(Helpで表示)                         */
  };

void *opt[]={&optPAT,&optNUM,&optCAT,&optCLS,&optTRN,&optTST,&optOTF,&optPML,
             &optDLM,&optTXT,
             &optCST,&optSEQ,&optEND,&optBGN,&optSIZ,&optSED,
             &optCAN,&optTRY,&optCNF,&optMIN,
             NULL};

struct mssFields *fpat; /*項目構造体*/
struct mssFields *fnum; /*項目構造体*/
struct mssFields *fcat; /*項目構造体*/
struct mssFields *fcls; /*項目構造体*/

char catCombi[1024][10];
void catMUtbl(){
  int rui[] ={1,2,4,8,16,32,64,128,256,512};
  int loop[]={512,256,128,64,32,16,8,4,2,1};
  int i,j,k,cnt;

  for(i=0; i<10; i++){
    cnt=0;
    for(j=0; j<loop[i]; j++){
      for(k=0; k<rui[i]; k++){
        catCombi[cnt++][i]='M';
      }
      for(k=0; k<rui[i]; k++){
        catCombi[cnt++][i]='U';
      }
    }
  }
  /*
  for(i=0; i<1024; i++){
    printf("i=%d : ",i);
    for(j=0; j<10; j++){
      printf("%c ",catCombi[i][j]);
    }
    printf("\n");
  }
  */
}

int main(int argc, char *argv[]){

  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/

  struct mssFPR    *trn=NULL; /*入力ファイル構造体*/
  struct mssFPR    *tst=NULL; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*テキスト出力ファイル構造体*/
  struct mssFPW    *fpwPMML=NULL; /*PMML出力ファイル構造体*/

  int PatFlg=0; /*パターン属性が指定されているかどうか*/
  int try=0;
  int trnCnt=0;
  int tstCnt=0;
  int searchCnt;
  struct Class   *cls;
  struct Cost    *cost;
  struct Map    **map;
  struct Category *category;
  struct Data    *trnDat;
  struct Data    *tstDat;
  struct Idxs    *idxs;
  struct Tree    *bestTree=NULL;
  struct Tree    *betterTree;
  struct Tree    *tree=NULL;
  int improved;
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

/*mssShowOption(opt);*/

  /*----------------------------*/
  /*パラメータ間の依存性チェック*/
  /*----------------------------*/
  /*説明属性が少なくとも一つは指定されているか*/
  if(!optPAT.set && !optNUM.set && !optCAT.set){
    mssShowErrMsg("it is needed at least one attriute on -p, -n or -d.");
    exit(mssErrorNoDefault);
  }

  /*パターン属性が指定されていればPatFlgをonにする*/
  if(optPAT.set) PatFlg=1;
  else           PatFlg=0;

  /*インデックスなしなのにマルチスタートチェック*/
  if(optSIZ.val==0 && optTRY.val>1)
    optTRY.val=1;

  /*モデルの種類は決定木に固定する*/
  optMDL.str="0";

  /*パラメータ省略時補間*/
  /*テストデータの指定がなければトレーニングをテストとして利用*/
  if(!optTST.set)optTST.str=mssStrdup(optTRN.str);

  /*カテゴリー属性が指定されていればcatMUtblをセットする*/
  if(optCAT.set) catMUtbl();

  /*----------------------------------------------*/
  /*入力ファイルオープン＆ヘッダー項目情報のセット*/
  /*----------------------------------------------*/
  trn=mssOpenFPR(optTRN.str,4); /*training File open*/
  tst=mssOpenFPR(optTST.str,4); /*test     File open*/
  hdi=mssReadHeader(trn);            /*項目名情報の読み込み*/

  mssSetOptFld(&optPAT, hdi);     /* -p 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optNUM, hdi);     /* -n 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optCAT, hdi);     /* -d 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optCLS, hdi);     /* -c 項目をヘッダー項目に関連づける     */
/*mssShowHeader(hdi);*/
  fpat=optPAT.flds; /*項目構造体*/
  fnum=optNUM.flds; /*項目構造体*/
  fcat=optCAT.flds; /*項目構造体*/
  fcls=optCLS.flds; /*項目構造体*/

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  trnCnt=countDat(trn);            /*トレーニングの件数カウント*/
  tstCnt=countDat(tst);            /*テストの件数カウント*/

  mssGV.inCnt=trnCnt;

  cls   =setClass(trn,tst,hdi);     /*クラスの数字-文字構造体セット*/
  ClassSize=cls->cnt;               /*クラスサイズをグローバルに*/

  cost  =readCost(optCST.str,cls);  /*コストファイルの読み込み*/
  map   =setMapAlp(trn,tst,hdi);    /*アルファベットのセット*/

/*showMap(*map);*/

  category = setCatHash(trn,tst,hdi); /*カテゴリ属性の文字列をhash表に登録*/
  trnDat=setDat(trn,hdi,cls,trnCnt,map,category); /*trainingのセット*/
  tstDat=setDat(tst,hdi,cls,tstCnt,map,category); /*testのセット*/
/*bonPrnDat(trnDat);*/
/*bonPrnDat(tstDat);*/

  /*--------------------------------------*/
  /*パターン項目が無ければ普通の決定木作成*/
  if(!PatFlg){
    switch(*optMDL.str){
    case '0':
      /*ツリー作成 updateTreeで開放*/
      tree = decisionTree(trnDat,tstDat,cost);
      break;
    }
    bestTree=updateTree(tree,bestTree);   /*ベストツリーの更新(とりあえず)*/

  }else{

    /*------------------------------*/
    /*パターン項目がある場合はbonsai*/
    /*ローカルサーチ マルチスタート*/
    bestTree=NULL;
    for(try=0; try<optTRY.val; try++){
      if(optSIZ.val!=0){
        mssShowMsg("Local Search Start: Trial No. %d",try+1);
      }

      betterTree=NULL;
      /*indexSize==0ならば、alphabetと同じサイズのインデックスを作る*/
      /*それ以外なら、ランダムにインデックスを一件用意 (後で開放)   */
      if(optSIZ.val==0) idxs=initIdxs0(trnDat);
      else              idxs=initIdxs(trnDat);

      /*改善がなくなるまで回す*/
      searchCnt=0;
      while(1){
        searchCnt++;
        improved=0;
        /*途中経過の表示*/
        if(optSIZ.val!=0){
          mssShowMsg("Iteration %d",searchCnt);
        }

        /*一文字だけ異なるindex群で回す*/
        for(i=0; i<idxs->cnt; i++){
          /*indexをコピー*/
          cpyIdx(trnDat,*(idxs->idx+i));

          /*alphabetデータをindexデータに変換(解放なし)*/
          datIndexing(trnDat);

          /*正規パターン侯補の作成 updateTreeで解放*/
          setRegTbl(trnDat,cost);

          /*各正規パターン侯補が有る無しの属性を作成 自身の中で開放*/
          mkAtt(trnDat);
          /*bonPrnDat(trnDat); bonPrnDat(tstDat);*/

          /*モデルの種類による分岐(for future)*/
          switch(*optMDL.str){
          case '0':
            /*ツリー作成 updateTreeで開放*/
            tree = decisionTree(trnDat,tstDat,cost);
            break;
          }

          /*途中経過の表示*/
          if(optSIZ.val!=0){
            showProgressTree(trnDat,tree);
          }
          /*showTree(tree,cost);*/
  
          /*より良いモデルの更新*/
          betterTree=updateTree(tree,betterTree);
          if(betterTree==tree){
            improved=1;
            if(optSIZ.val!=0){
              mssShowMsg("IMPROVED");
            }
          }
        } /*for*/
        freeIdxs(idxs);
  
        /*改善がない、もしくはindexSize==0の時はブレーク*/
        if(!improved || optSIZ.val==0){
          break;
  
        /*改善があればインデックスを変えてさらに探索*/
        }else{
          idxs=setNextIdxs(betterTree->dat);
          continue;
        }
      }/*while*/
  
      bestTree=updateTree(betterTree,bestTree);   /*ベストツリーの更新*/
  
    } /*try*/
    freeAtt(trnDat);
    freeRegTbl(trnDat);
  } /*bonsai*/

  /*出力ファイルオープン*/
  fpw=mssOpenFPW(optOTF.str,0,0);

  /*結果の表示*/
  showTree(bestTree,cost,fpw);

  if(optPML.set){
    fpwPMML=mssOpenFPW(optPML.str,0,0);
    showTreePMML(bestTree,cost,fpwPMML);
  }

  /*領域開放*/
  freeTree(bestTree);
  freeDat(tstDat);
  freeDat(trnDat);
  for(i=0; i<fcat->cnt; i++){
    mssFree((category+i)->name);
    mssFree((category+i)->valName);
  }
  mssFree(category);
  freeMap(map);
  mssFree(cost);
  freeClass(cls);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(trn);       /*Training File close         */
  mssCloseFPR(tst);       /*Test     File close         */
  mssCloseFPW(fpw);       /*テキスト出力 File close     */
  if(optPML.set)
    mssCloseFPW(fpwPMML); /*PMML出力 File close         */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
