
/*----------------------------------------------------------------------------*/
/* 構造体                                                                     */
/*----------------------------------------------------------------------------*/
/*stateを複数格納するための構造体(nsal,targetStatesで利用) */
struct StateList{
  int *state;
  int cnt;
};

struct DASG {
  int **direction;                 /*各ステートの各アルファベットのarc先state*/
  int *match;                      /*各stateまでに何回マッチしたか*/
  int *refCnt;                     /*各stateに何個のarcがあるか*/
  int *nsaCnt;                     /*各stateに何個のnonSolidArcがあるか*/
  struct StateList ***nsal;        /*nonSolidArcList*/
  struct StateList **targetStates; /*各アルファベットのnonSolidArcを持つState*/
  int stateCnt;                    /*stateの個数(随時カウントアップされる)*/
  int alpCnt;                      /*アルファベットのサイズ(随時更新される)*/
  struct mssHashNode **alpTbl;     /*アルファベットとその番号の対応表*/
  int maxCnt;                      /*最も多い件数*/
};


/*----------------------------------------------------------------------------*/
/* 関数プロトタイプ宣言                                                       */
/*----------------------------------------------------------------------------*/
int DASGqueryCnt(struct DASG *dasg,struct mssHashNode **s, int n);
void DASGshow(struct DASG *dasg);
struct DASG *DASGinit(int size);
void DASGfree(struct DASG *dasg);
void DASGaddStr(struct DASG *dasg,struct mssHashNode **str, int n);
void DASGwriteXt(struct DASG *dasg,int minDepth,int maxDepth,int support, char **pnt,MssOptKEY *optKEY,struct mssFPW *fpw);

