
struct SuffixNode {
  struct mssHashNode *str;  /*文字(hashのアドレスとして)*/
  struct SuffixNode **next; /*子供SuffixNode*/
  int nextCnt;              /*子供SuffixNodeの個数*/
  int workNo;               /*ノードが現在処理中のレコードを既に処理したか
                              を確認するために、その番号が更新される*/
  int cnt;                  /*このノードまでの文字列にマッチした件数*/
  int depth;                /*このノードの深さ*/
};

struct SuffixTree {
  struct SuffixNode *top; /*トップノード*/
  int maxDepth;           /*深さの最大値(constant)*/
  int maxCnt;             /*最大件数をこの変数に更新する*/
  int recNo;              /*現在処理中のレコード番号*/
};

struct SuffixTree *SUFXinit(int depth);
void SUFXfree(struct SuffixTree *st);
void SUFXaddStr(struct SuffixTree *st, struct mssHashNode **str, int n);
int SUFXqueryCnt(struct SuffixTree *st,struct mssHashNode **str,int n);
void SUFXshow(struct SuffixTree *st);
void SUFXwriteXt(struct SuffixTree *st,int minDepth,int maxDepth,int recNo,int support,char **pnt, MssOptKEY *optKEY,struct mssFPW *fpw);

