/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : 新しいAPIへの対応 2003/07/19                                         */
/* 1.1 : 出力項目番号の不具合修正 2003/11/19                                  */
/*============================================================================*/
#include <musashi.h>
#include <suffixTree.h>
#include <dasg.h>
#include <xtcntseqHelp.h>

#include <stdlib.h>
#include <limits.h>

struct mssComHelp comHelp={
  "xtcntseq",     /* コマンド名       */
  "1.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

/*----------------------------------------------------------------------------*/
/*originalの項目文字列をhash表に登録し、そのアドレスをseqテーブルに登録する   */
/*----------------------------------------------------------------------------*/
struct mssHashNode **setSeqDat(
  struct mssHashNode **seq, /*シーケンスが入る配列*/
  struct mssHash *hash,     /*登録するhash表*/
  int *keyCnt,           /*シーケンスのカウンタ*/
  char *str){            /*登録するoriginal文字列*/

  struct mssHashNode *hn;  /*登録されたhashNodeへのポインタ*/
  MssValue v;              /*hash表への登録用ダミー*/

  mssVinit(&v,STR);
  hn=mssHashInsertAdd(hash,str,v);
  seq=mssRealloc(seq,sizeof(struct mssHashNode *)*(*keyCnt+1),"seq1");
  *(seq+*keyCnt)=hn;
  (*keyCnt)++;

  return(seq);
}

int main(int argc, char *argv[]){
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンス一行を識別するための項目                                         */
/*----------------------------------------------------------------------------*/
  MssOptKEY optUNT={
    OKEY,   /* オプションタイプ                                             */
    "u",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    UNTT,   /* このオプションのタイトル(Helpで表示)                         */
    UNTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ソート項目                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optSRT={
    OFLD,   /* オプションタイプ                                             */
    "s",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    "n,r",  /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    SRTT,   /* このオプションのタイトル(Helpで表示)                         */
    SRTC,   /* このオプションのコメント(Helpで表示)                         */
    SRTF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* シーケンスの値のデータ項目                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    1,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 選択件数                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptINT optCNT={
    OINT,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    10,     /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    CNTT,   /* このオプションのタイトル(Helpで表示)                         */
    CNTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 選択件数(割合)                                                             */
/*----------------------------------------------------------------------------*/
  MssOptDBL optPCT={
    ODBL,   /* オプションタイプ                                             */
    "p",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    5,      /* デフォルト(数値として指定)                                   */
    0,      /* 最小値                                                       */
    100,    /* 最大値                                                       */
    PCTT,   /* このオプションのタイトル(Helpで表示)                         */
    PCTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンスの長さ                                                           */
/*----------------------------------------------------------------------------*/
  MssOptRNG optLEN={
    ORNG,   /* オプションタイプ                                             */
    "l",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "2_5",  /* デフォルト(文字列として指定する)                             */
    1,      /* カンマで区切られる要素数の最大値                             */
    1,      /* 値の最小値                                                   */
    50,     /* 値の最大値                                                   */
    LENT,   /* このオプションのタイトル(Helpで表示)                         */
    LENC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* サブシーケンス                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSSQ={
    OFLG,   /* オプションタイプ                                             */
    "Q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SSQT,   /* このオプションのタイトル(Helpで表示)                         */
    SSQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "sequence,no,len,cnt,totalCnt", /* デフォルト(文字列)                   */
    5,      /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldNameMaxLen,/* 各要素の文字列長の最大値                          */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* シーケンシャル処理                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* オプションタイプ                                             */
    "q",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    SEQT,   /* このオプションのタイトル(Helpで表示)                         */
    SEQC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optUNT,&optSRT,&optFLD,&optCNT,&optPCT,&optLEN,&optSSQ,
               &optFNM,&optSEQ,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo=NULL; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRecDbl *frd=NULL; /*項目-キーバッファ構造体*/
  struct mssFields    *sf;  /*ソート項目構造体     */

  int ukb,kkb;  /*キーブレークフラグ*/
  int sorted;            /*ソート済チェック用*/
  int keyCnt;
  int recNo;
  struct mssHash *hash;
  struct mssHashNode **seq; /*シーケンスが入る配列*/
  int supportCnt;

  struct SuffixTree *suffix=NULL; /*サフィックスツリーのトップノード*/
  struct DASG       *dasg  =NULL;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
  mssSetOptKey(&optUNT, hdi);        /* -u 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optSRT, hdi);        /* -s 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */

  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssAddFieldsByFields(sf,optUNT.flds); /* -u 項目をソート項目としてセット    */
  mssAddFieldsByFields(sf,optSRT.flds); /* -s 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
  sorted=mssChkSorted(sf,hdi);          /* ソート済かチェック                 */

/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

  /*-aを指定する時、個数は５つでなければならない*/
  if(optFNM.set && optFNM.cnt!=5){
    mssShowErrMsg("must specify five field names on -a");
    mssEnd(mssErrorNoDefault);
  }

  if(!optCNT.set && !optPCT.set){
    mssShowErrMsg("must specify either -c or -p");
    mssEnd(mssErrorNoDefault);
  }
/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  mssAddFieldsByFields(hdo->flds,optKEY.flds);
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+0)); /*unit項目名の追加*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+1)); /*no項目名の追加*/
  mssAddFieldsByFields(hdo->flds,optFLD.flds);
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+2)); /*len項目名の追加*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+3)); /*cnt項目名の追加*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+4)); /*totalCnt項目名の追加*/

  /* 全項目に項目番号を登録順にふる */                                        
  mssSetFieldsSequenceNum(hdo->flds);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /*ソートが必用ならばソートしてソート済みファイルとしてオープン*/
  if(!optSEQ.set && !sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*FRD構造体の初期化*/
  frd=mssInitFRD(hdi->flds->cnt);

  seq=NULL;                   /*各単位ごとのシーケンス配列*/
  keyCnt=0;                   /*シーケンス内にいくつ要素があるか*/
  recNo=0;                    /*key内で何番目のシーケンスか(start from 1)*/
  if(optSSQ.set) dasg  =DASGinit(3);  /*dasgの初期化*/
  else           suffix=SUFXinit(10); /*suffixTreeの初期化*/
  hash=mssInitHash(101);         /*ハッシュテーブルの作成(項目値)*/
  if(!optSSQ.set) seq=setSeqDat(seq,hash,&keyCnt,"^");
  while( EOF!=mssReadFRD(fpr,frd) ){

    /*キーブレイク時の処理*/
    kkb=mssKeyBreak(frd, &optKEY);
    ukb=mssKeyBreak(frd, &optUNT);
    if(kkb || ukb){ /*-k or -u のキーブレーク*/
      if(!optSSQ.set) seq=setSeqDat(seq,hash,&keyCnt,"$");
      if(optSSQ.set)  DASGaddStr(dasg  ,seq,keyCnt);
      else            SUFXaddStr(suffix,seq,keyCnt);
      mssFree(seq);
      seq=NULL;
      keyCnt=0;
      recNo++;
      if(!optSSQ.set) seq=setSeqDat( seq,hash,&keyCnt,"^");
    }
    if(kkb){ /*-k のキーブレーク*/
      if(optSSQ.set){
        /*サポート件数のセット*/
        if(optCNT.set) supportCnt=optCNT.val;
        else           supportCnt=(int)((optPCT.val/(double)100)*(double)recNo);
        /*DASGshow(dasg);*/
        DASGwriteXt(dasg,*optLEN.from,*optLEN.to,supportCnt,frd->pnt[frd->old],&optKEY,fpw);
        DASGfree(dasg);
        dasg=DASGinit(3);
      }else{
        /*サポート件数のセット*/
        if(optCNT.set) supportCnt=optCNT.val;
        else           supportCnt=(int)((optPCT.val/(double)100)*(double)recNo);
        /*SUFXshow(suffix); */
        SUFXwriteXt(suffix,*optLEN.from,*optLEN.to,recNo,supportCnt,frd->pnt[frd->old],&optKEY,fpw);
        SUFXfree(suffix);
        suffix=SUFXinit(10); /*suffixTreeの初期化*/
      }

      mssFreeHash(hash);
      hash=mssInitHash(101);
      recNo=0;  /*key内で何番目のシーケンスか(start from 1)*/
      mssFree(seq);
      seq=NULL;
      keyCnt=0;
      if(!optSSQ.set) seq=setSeqDat( seq,hash,&keyCnt,"^");

      if(frd->eof) break;
    }

    mssGV.inCnt++;
    /*通常行の処理(集計値の計算)*/
    seq=setSeqDat( seq,hash,&keyCnt,*(frd->pnt[frd->new]+MssFlds2num(optFLD.flds,0)) );

  }
  if(optSSQ.set) DASGfree(dasg);
  else           SUFXfree(suffix);
  mssFree(seq);
  mssFreeHash(hash);
  mssFreeFRD(frd);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeFields(sf);      /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
