/**
 * # CHAPTER #
 * ============================================================================
 * 領域分割に関するヘッダーファイル
 * ============================================================================
 */

#define MALLOC_CNT 200
#define XMAX 1024
#define YMAX 1024
#define DBLMINVAL -3.4E+38
#define DBLMAXVAL 3.4028E+38

#define Ar1(a,x)     (a+(x))
#define Ar2(a,x,y)   (a+(y)*cntTbl->xCnt+(x))
#define Ar3(a,x,y,z) (a+(z)*cntTbl->yCnt*cntTbl->xCnt+(y)*cntTbl->xCnt+(x))
#define Ar2p1(a,x,y) (a+(y)*((cntTbl->xCnt)+1)+(x))

/**
 * # STRUCT #
 * 一つのセル(pixel)のデータを格納する構造体
 */
struct CntCel {
  long negCnt;
  long posCnt;
  long total;
  double        weight;
};

struct RTBL {
  double from;
  double to;
};

/**
 * # STRUCT #
 * 全領域のデータを格納する構造体
 */
struct CntTbl {
  struct CntCel   tbl[XMAX][YMAX]; /*対象とする配列 (要素は1から)*/
  struct RTBL     rtbl[2][XMAX];   /*範囲配列*/
  int             xCnt;            /*対象とする配列のXの最大要素数*/
  int             yCnt;            /*対象とする配列のYの最大要素数*/
  long   sup;                      /*トータルのサポート件数 sup(N)*/
  long   hit;                      /*トータルのヒット件数 hit(N)*/
};

/**
 * -----------------------------------------------------------------------------
 * X単調,Y単調で利用する構造体
 * -----------------------------------------------------------------------------
 */

/**
 * 各列におけるスタート位置と終了位置、ウエイト、前列のjの値
 */
struct REGBDY {
  int    start;
  int    end;
  double weight;
  int    optJ;   /*0はリンクなしを意味する*/
};

/**
 * X,Y単調領域で使う,一時的な領域情報
 */
struct REGION {
  struct REGBDY *tbl;
  int    maxX;                   /*ウエイトが最も大きくなるXの要素番号*/
  int    maxY;                   /*ウエイトが最も大きくなるYの要素番号*/
  double maxWeight;              /*ウエイトが最も大きくなるweightの値*/
};

/**
 * max w[1,i] w[j,N] の最適解を保存しておくための構造体
 */
struct W1IJN {
  int    start;
  double weight;
};

/**
 *
 */
struct WSUB {
  struct W1IJN *w1i; /*行1〜i までの合計weight (1次元配列)*/
  struct W1IJN *wjN; /*行j〜N までの合計weight (1次元配列)*/
  double       *w1u; /*行1〜u までの合計weight (1次元配列)*/
  double       *wvN; /*行v〜N までの合計weight (1次元配列)*/
  double        w1N;
};

/**
 * -----------------------------------------------------------------------------
 * 長方形で利用する構造体
 * -----------------------------------------------------------------------------
 */
struct HSSUB {
  long *h1u; /*hit     from 1 to u(2次元配列)*/
  long *s1u; /*support from 1 to u(2次元配列)*/
  long *hvN; /*hit     from v to N(2次元配列)*/
  long *svN; /*support from v to N(2次元配列)*/
  long *h1N; /*hit     from 1 to N(1次元配列)*/
  long *s1N; /*support from 1 to N(1次元配列)*/
};

/**
 * -----------------------------------------------------------------------------
 * rectLinewr(XY単調)で利用する構造体
 * -----------------------------------------------------------------------------
 */

/**
 *
 */
struct XYBDY {
  char type; /*0:null 1:wide 2:upper 3:down 4:narrow*/
  short m;
  short s;
  short t;
  float weight;
};

/**
 *
 */
struct XYTBL {
  struct XYBDY fw;
  struct XYBDY fu;
  struct XYBDY fd;
  struct XYBDY fn;
};

/**
 * -----------------------------------------------------------------------------
 * 最適領域を記憶する構造体(各領域共通で利用)
 *                region nonregion total
 * actual positive  posO   posX      posOX
 * actual negative  negO   negX      negOX
 * total            supO   supX      supOX
 * -----------------------------------------------------------------------------
 */
struct SELREG {
           char   *tbl;    /*領域のXY配列(0:非領域 1:選択領域)*/
  struct RTBL      rtbl[2][XMAX]; /*領域の範囲*/
           int     xCnt;
           int     yCnt;
           double  theta;  /*θの値(長方形領域で未使用)*/
           double  weight; /*weightの値(長方形領域で未使用)*/
  long    sup;    /*選択された領域のサポート件数*/
  long    hit;    /*選択された領域のヒット件数*/
           double  objVal; /*目的関数の評価値*/
           double  variance;/*クラス間分散の値*/
           double  entropy; /*エントロピーゲインの値*/
           double  gini;    /*giniの値*/
           double  accuracy;/*正解率の値*/

  long    supOX;
  long    supO;
  long    supX;
  long    posOX;
  long    posO;
  long    posX;
  long    negOX;
  long    negO;
  long    negX;
           int     fcNo;
           int     fcNoX;
           int     fcNoY;
};



struct CntTbl *initCntTbl(int x, int y);
void setCntTblByCell(struct CntTbl *cntTbl, int x, int y, int hit, int sup);
void adjustNulCntTbl( struct CntTbl *cntTbl, char *nul);
void deajustNulCntTbl( struct CntTbl *cntTbl, struct SELREG *selReg);
void dispCntTbl(struct CntTbl *cntTbl);
void dispCntTblWeight(struct CntTbl *cntTbl);
void dispCntTblHitRatio(struct CntTbl *cntTbl);
struct SELREG *segRegion(struct CntTbl *cntTbl, char *type, char *nul);
void dispSelReg(struct SELREG *selReg);

