/*============================================================================*/
/* 画像データなどのデータからの領域を切り出す                                 */
/*----------------------------------------------------------------------------*/
/* 変更履歴                                                                   */
/* 1.0 : 初期作成 2003/08/07                                                  */
/* 1.1 : ヘルプのタイトルがおかしいの修正 2003/10/15                          */
/*============================================================================*/
#include <musashi.h>
#include <region.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <float.h>

#include <xtregionsegHelp.h>

struct mssComHelp comHelp={
  "xtregionseg",  /* コマンド名       */
  "1.0",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){

/*----------------------------------------------------------------------------*/
/* X                                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLD optX={
    OFLD,   /* オプションタイプ                                             */
    "H",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    HOLT,   /* このオプションのタイトル(Helpで表示)                         */
    HOLC,   /* このオプションのコメント(Helpで表示)                         */
    HOLF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* Y                                                                          */
/*----------------------------------------------------------------------------*/
  MssOptFLD optY={
    OFLD,   /* オプションタイプ                                             */
    "V",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    VERT,   /* このオプションのタイトル(Helpで表示)                         */
    VERC,   /* このオプションのコメント(Helpで表示)                         */
    VERF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* HIT項目名                                                                  */
/*----------------------------------------------------------------------------*/
  MssOptFLD optHTF={
    OFLD,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    HTFT,   /* このオプションのタイトル(Helpで表示)                         */
    HTFC,   /* このオプションのコメント(Helpで表示)                         */
    HTFF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* Support項目名(optSPF,optSPVは排他的)                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optSPF={
    OFLD,   /* オプションタイプ                                             */
    "s",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    1,      /* 指定可能な最大項目数                                         */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    SPFT,   /* このオプションのタイトル(Helpで表示)                         */
    SPFC,   /* このオプションのコメント(Helpで表示)                         */
    SPFF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 要素の最大値(optSPF,optSPVは排他的)                                        */
/*----------------------------------------------------------------------------*/
  MssOptINT optSPV={
    OINT,   /* オプションタイプ                                             */
    "M",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    0,      /* デフォルト(数値として指定)                                   */
    1,      /* 最小値                                                       */
    INT_MAX,/* 最大値                                                       */
    SPVT,   /* このオプションのタイトル(Helpで表示)                         */
    SPVC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* サイズ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptILS optSIZ={
    OILS,   /*オプションタイプ*/
    "S",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /*デフォルト(文字列で)                                          */
    2,      /*リスト要素の最大数                                            */
    1,      /*要素の最小値                                                  */
    3200,   /*要素の最大値                                                  */
    SIZT,   /*パラメータタイトル                                            */
    SIZC    /*パラメータコメント                                            */
};

/*----------------------------------------------------------------------------*/
/* 領域の形                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSEL optRTP={
    OSEL,   /* オプションタイプ                                             */
    "r",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列にて)                                       */
    "x,y,xy,rect",
            /* 指定可能な値リスト                                           */
    RTPT,   /* このオプションのタイトル(Helpで表示)                         */
    RTPC,   /* このオプションのコメント(Helpで表示)                         */
    RTPS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* NULL値の扱い                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSEL optNUL={
    OSEL,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "negative", /* デフォルト(文字列にて)                                   */
    "positive,negative",
            /* 指定可能な値リスト                                           */
    NULT,   /* このオプションのタイトル(Helpで表示)                         */
    NULC,   /* このオプションのコメント(Helpで表示)                         */
    NULS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 新項目名                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* オプションタイプ                                             */
    "a",    /* キーワード(複数文字は不可)                                   */
    2,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    1,      /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldNameMaxLen,/* 各要素の文字列長の最大値                          */
    0,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    FNMT,   /* このオプションのタイトル(Helpで表示)                         */
    FNMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optX,&optY,&optHTF,&optSPF,&optSPV,&optSIZ,&optRTP,&optNUL,
               &optFNM,&optINF,&optOTF,&optZIP,&optTXT,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  static struct CntTbl    *cntTbl;
  static struct SELREG    *region;

  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssFldRec *fr; /*項目-行バッファ構造体*/

  int xNo,yNo,hNo,sNo;
  int x,y,hit,sup;
/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

  if( optSPF.set + optSPV.set != 1 ){
    mssShowErrMsg("must specify one of -s or -M");
    mssEnd(mssErrorNoDefault);
  }

  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optX  , hdi);        /* -H 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optY  , hdi);        /* -V 項目をヘッダー項目に関連づける     */
  mssSetOptFld(&optHTF, hdi);        /* -V 項目をヘッダー項目に関連づける     */

  xNo=MssFlds2num(optX.flds,0); /*X軸項目番号*/
  yNo=MssFlds2num(optY.flds,0); /*Y軸項目番号*/
  hNo=MssFlds2num(optHTF.flds,0); /*hit項目番号*/
  if(optSPF.set){
    mssSetOptFld(&optSPF, hdi);      /* -V 項目をヘッダー項目に関連づける     */
  }

  if(optSPF.set){
    sNo=MssFlds2num(optSPF.flds,0); /*support項目番号*/
  }else{
    sNo=0; /* to avoid warning message */
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*新項目名の追加*/
  mssAddFieldsByStrList(hdo->flds,optFNM.strList,optFNM.cnt);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);


/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/

/* データのセット */
  /*cntTblの初期化*/
  cntTbl=initCntTbl(*(optSIZ.val+0),*(optSIZ.val+1));

  /*cntTblにデータをセットする*/
  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;

    x=atoi( *(fr->pnt+xNo) );
    y=atoi( *(fr->pnt+yNo) );
    hit=atoi( *(fr->pnt+hNo) );
    if(optSPF.set) sup=atoi( *(fr->pnt+sNo) );
    else           sup=optSPV.val;

    setCntTblByCell(cntTbl, x, y, hit, sup);
  }

/*dispCntTbl(cntTbl);*/
/*dispCntTblHitRatio(cntTbl);*/

  /* 領域の取得 */
  region=segRegion(cntTbl, optRTP.str, optNUL.str);

  /* 出力 */
  mssSeekTopFPR(fpr);
  while( EOF != mssReadFldRec(fpr,fr) ){
    x=atoi( *(fr->pnt+xNo) );
    y=atoi( *(fr->pnt+yNo) );
    mssWriteFld(fr->pnt,fr->fldCnt," ",fpw);
    mssWriteInt(*(region->tbl + region->xCnt*(y+1)+x+1),fpw);
    mssWriteRet(fpw);
  }

  dispSelReg(region);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPR(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
