/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <chkfnrHelp.h>
struct mssComHelp comHelp={
  "chkfnr",       /* コマンド名       */                                    
  "0.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */                                      
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

/*
範囲が重なっていない:1
範囲が重なっている:0
ファイル名範囲がおかしい:-1
*/
int cmpRange(char *str, char *Small, char *Big, char delim, int smallEql, int bigEql){
  char *r1=str;
  char *r2=NULL;
  char *small;
  char *big;
  char *tmp;

  tmp=str+strlen(str);
  while(tmp!=str){
    if(*tmp=='.'){
      *tmp='\0';
      break;
    }
    tmp--;
  }

  tmp=str+strlen(str);
  while(tmp!=str){
    if(*tmp=='/'){
      r1=tmp+1;
      break;
    }else if(*tmp==delim){
      *tmp='\0';
      r2=tmp+1;
    }
    tmp--;
  }
  if(r2==NULL) return(-1);

  if(0>=strcmp(r1,r2)){
    small=r1; big=r2;
  }else{
    small=r2; big=r1;
  }
 
  if(bigEql){
    /*Big<=small*/
    if(0>=strcmp(Big,small)) return(1);
  }else{
    /*small>Big*/
    if(0> strcmp(Big,small)) return(1);
  }

  if(smallEql){
    /*big=<Small*/
    if(0>=strcmp(big,Small)) return(1);
  }else{
    /*big<Small*/
    if(0> strcmp(big,Small)) return(1);
  }
  /*else*/
  return(0);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 同じ値の取扱                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSEL optEQL={
    OSEL,   /* オプションタイプ                                             */
    "e",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "okok", /* デフォルト(文字列にて)                                       */
    "okok,okng,ngok,ngng",
            /* 指定可能な値リスト                                           */
    EQLT,   /* このオプションのタイトル(Helpで表示)                         */
    EQLC,   /* このオプションのコメント(Helpで表示)                         */
    EQLS    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 範囲1                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptSTR optRNG1={
    OSTR,   /* オプションタイプ                                             */
    "F",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NULL  , /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    RNG1T,  /* このオプションのタイトル(Helpで表示)                         */
    RNG1C   /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 範囲2                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptSTR optRNG2={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    NULL  , /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    RNG2T,  /* このオプションのタイトル(Helpで表示)                         */
    RNG2C   /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* デリミター                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optDLM={
    OSTR,   /* オプションタイプ                                             */
    "D",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    "-",    /* デフォルト                                                   */
    1,      /* 文字列の最小長                                               */
    1,      /* 文字列の最大長                                               */
    DLMT,   /* このオプションのタイトル(Helpで表示)                         */
    DLMC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    256,    /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optEQL,&optRNG1,&optRNG2,&optDLM,&optINF,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  int cmp;
  int i;
  char *rng1,*rng2;
  int smallEql,bigEql;
  int ret=0;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

  if(0>=strcmp(optRNG1.str,optRNG2.str)){
    rng1=optRNG1.str; rng2=optRNG2.str;
  }else{
    rng1=optRNG2.str; rng2=optRNG1.str;
  }

  if(strcmp(optEQL.str,"okok")==0){
    smallEql=1; bigEql=1;
  }else if(strcmp(optEQL.str,"okng")==0){
    smallEql=1; bigEql=0;
  }else if(strcmp(optEQL.str,"ngok")==0){
    smallEql=0; bigEql=1;
  }else{
    smallEql=0; bigEql=0;
  }

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  for(i=0; i<optINF.cnt; i++){
    cmp=cmpRange(*(optINF.strList+i), rng1, rng2, *optDLM.str,smallEql,bigEql);
    if(cmp==-1) continue;
    if(cmp==0){
      ret=1;
      break;
    }
  }

/*----------------------------------------------------------------------------*/
/*終了処理                                                                    */
/*----------------------------------------------------------------------------*/
  mssFreeOption(opt);   /* オプション領域開放         */                    
  mssShowEndMsg();      /* 完了メッセージ             */
  mssEnd(ret);          /* 終了                       */
  return(0);            /* to avoid warning message   */
}
