/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <ptrepenvHelp.h>
struct mssComHelp comHelp={
  "ptrepenv",     /* コマンド名       */
  "0.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

struct Buffer {
  char *curStr;
  char *envNam;
  char *preStr;
};

void getNextEnv(struct Buffer *buf){
  char *str;
  char *end;

  buf->preStr=buf->curStr;
  str=buf->curStr;

  while(1){
    str=strstr(str,"${");
    if(str==NULL) {
      buf->curStr=NULL;
      buf->envNam=NULL;
      return;
    }else{
      end=strchr(str,'}');
      if(end==NULL){
        str++;
        continue;
      }else{
        buf->envNam=mssCalloc(sizeof(char)*(end-str-1),"getNextEnv");
        strncpy(buf->envNam,str+2,end-str-2);
        buf->curStr=end+1;
        *str='\0';
        return;
      }
    }
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optINF,&optOTF,&optZIP,NULL};

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssRec    *rec; /*行バッファ構造体*/
  char *val;
  struct Buffer buf;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /* 入出力ファイルオープン */
  fpr=mssOpenFPR(optINF.str,4);
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  buf.curStr=NULL;
  rec=mssInitRec();
  while(EOF != mssReadRec(fpr,rec)){
    mssGV.inCnt++;
    buf.curStr=rec->pnt;
    buf.envNam=NULL;
    buf.preStr=NULL;
    while(1){
      getNextEnv(&buf);
      mssWriteStr(buf.preStr,fpw);

      /*envNamがnullということはその行にenvはない*/
      if(buf.envNam==NULL){
        mssWriteRet(fpw);
        mssGV.outCnt++;
        break;
      }else{
        val=getenv(buf.envNam);
        /*envNamが登録されていなければそのまま出力*/
        if(val==NULL){
          mssWriteStr("${",fpw);
          mssWriteStr(buf.envNam,fpw);
          mssWriteStr("}",fpw);

        /*envNamが登録されていれば値を出力*/
        /*XMLで使用できない文字をentity(ex.&lt;)に変換予定*/
        }else{
          mssWriteStr(val,fpw);
        }
        mssFree(buf.envNam);
      }
    }
  }
  mssFreeRec(rec);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);     /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);     /* 出力ファイルのクローズ     */
  mssFreeOption(opt);   /* オプション領域開放         */
  mssShowEndMsg();      /* 完了メッセージ             */
  return(0);            /* to avoid warning message   */
}

