/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <ptrepfileHelp.h>
struct mssComHelp comHelp={
  "ptrepfile",    /* コマンド名       */
  "0.1",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

struct PrefixNode {
  char chr;                 /*ノードにおける文字*/
  char *val;                /*環境変数の値(リーフの時にセットされる)*/
  int  cnt;                 /*ノードが持つ子供の数*/
  struct PrefixNode **next; /*次のノードへのリスト(cntの数だけある)*/
};

/*prefixTreeの出力(デバッグ用)*/
void prnPrefixTree(struct PrefixNode *pn,int depth){
  int i;

  for(i=0; i<depth; i++) printf(" ");
  printf("%c [%s] %d\n",pn->chr,pn->val,pn->cnt);
  if(pn->cnt==0) return;

  for(i=0; i<pn->cnt; i++){
    prnPrefixTree( *(pn->next+i), depth+1 );
  }
}

/*prefixTreeの開放(トップノードは開放されない)*/
void freePrefixTree(struct PrefixNode *pn){
  int i;

  if(pn->cnt==0){
    mssFree(pn->val);
    return;
  }

  for(i=0; i<pn->cnt; i++){
    freePrefixTree( *(pn->next+i));
  }
  for(i=0; i<pn->cnt; i++){
    mssFree(*(pn->next+i));
  }
  mssFree(pn->next);
}

/*文字列repStrをprefixツリーに登録する*/
/*葉ノードにはvalが登録される*/
void setPrefixTree(struct PrefixNode *pn,char *repStr,char *val){
  struct PrefixNode *nextNode=NULL;
  int i;

  /*置換文字列の終端に達していれば環境変数値をセットしてリターン*/
  if(*repStr=='\0'){
    if(pn->val!=NULL) return; /*既に登録済ということは同じ文字列ということ*/
    if(val==NULL) pn->val=mssStrdup("");
    else          pn->val=mssStrdup(val);
    return;
  }

  /*次のノードを検索*/
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == *repStr ){
      nextNode=*(pn->next+i);
      break;
    }
  }

  if( nextNode==NULL ){
    /*次のノードを作成*/
    pn->next=mssRealloc(pn->next,sizeof(struct PrefixNode *)*(pn->cnt+1),"setPT");
    nextNode=*(pn->next+pn->cnt)=mssCalloc(sizeof(struct PrefixNode),"newPN");
    pn->cnt++;

    /*ノードの文字をセット*/
    nextNode->chr=*repStr;
  }

  /*再帰コール*/
  setPrefixTree(nextNode,repStr+1,val);
  return;
}

/*文字chrによって次のprefixノードを返す(なければNULLを返す)*/
struct PrefixNode *nextNode(struct PrefixNode *pn,char chr){
  int i;
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == chr ){
      return(*(pn->next+i));
      break;
    }
  }
  return(NULL);
}

void outputFile(char *fileName){
  FILE *fp;
  int c;
  fp=fopen(fileName,"r");
  if(fp==NULL) return;

  while(EOF!=(c=fgetc(fp))){
    putchar(c);
  }
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* 置換条件                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optREP={
    OSLS,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    256,    /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    256,    /* 各要素の文字列長の最大値                                   */
    1,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    REPT,   /* このオプションのタイトル(Helpで表示)                         */
    REPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optREP,&optINF,&optOTF,&optZIP,NULL};

  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  struct mssRec    *rec; /*行バッファ構造体*/

  char *val;
  char *repStr;
  struct PrefixNode *pt;
  struct PrefixNode *pn;
  char *str;
  int i,mcnt;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */

/*----------------------------------------------------------------------------*/
/* 指定された置換対象文字列をprefixTreeにセット                               */
/* リーフには置換文字列をセット                                               */
/* 同じ環境変数名の指定があった場合は、前に指定された変数を優先する           */
/*----------------------------------------------------------------------------*/
  pt=mssCalloc(sizeof(struct PrefixNode),"newPN");
  for(i=0; i<optREP.cnt; i++){

    /*置換対象文字列*/
    repStr    =*(optREP.strList+i);

    /*ファイル名*/
    val=*(optREP.colList+i);
    if(val==NULL){ /*オプションでファイル名の指定がなければエラー*/
      mssShowErrMsg("have to specify file name on -c");
      mssEnd(mssErrorNoDefault);
    }

    /*prefix treeに登録*/
    setPrefixTree(pt,repStr,val);
  }

/*prnPrefixTree(pt,0);*/

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  /* 入出力ファイルオープン */
  fpr=mssOpenFPR(optINF.str,4);
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

  rec=mssInitRec();
  pn=pt;
  while(EOF != mssReadRec(fpr,rec)){
    mssGV.inCnt++;
    str=rec->pnt;
    mcnt=0; /*prefixTreeをたどっている時、最初の一致した位置を相対的にカウント*/
    while(1){

      /*終端で改行し次の行へ*/
      if(*str=='\0'){
        mssWriteRet(fpw);
        break;
      }

      /*現在の文字をprefixツリーに当てはめ、そのノードを取得*/
      pn=nextNode(pn,*str);

      /*nodeがNULLということは、一致する文字列が無かったということ*/
      if(pn==NULL){
        for(i=mcnt; i<=0; i++) mssWriteChr(*(str+i),fpw);
        mcnt=0;
        pn=pt;

      /*現在のprefixツリーnodeのvalが存在するということは
        マッチしたということで、ファイルの内容を出力*/
      }else if(pn->val!=NULL){
        outputFile(pn->val);
        pn=pt;
        mcnt=0;

      /*上記の条件以外ということは、途中までマッチ中であるということ*/
      }else{
        mcnt--;
      }
      str++;
    }
    mssGV.outCnt++;
  }
  mssFreeRec(rec);

  freePrefixTree(pt);
  mssFree(pt);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);     /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);     /* 出力ファイルのクローズ     */
  mssFreeOption(opt);   /* オプション領域開放         */
  mssShowEndMsg();      /* 完了メッセージ             */
  return(0);            /* to avoid warning message   */
}
