/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/* 0.2 : オプションの与え方を変更 2003/08/18                                  */
/* 0.3 : ファイルロック(共有ロック)機能追加 2003/09/26                        */
/* 0.4 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>

#include <xtbsselstrHelp.h>
struct mssComHelp comHelp={
  "xtbsselstr",   /* コマンド名       */
  "0.4",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

/**
 * 範囲キーの構造体
 * 範囲を指定できるのは、最後の文字列のみ
 * ex)
 */
struct RangeKey {
  int   *fldNo; /*各項目の番号*/
  char  **str;
  char  *from;
  char  *to;
  int    cnt;
};

int keyCmp(char **str1, char **str2, struct RangeKey *rkey){
  int i;
  int cmp=0;

  for(i=0; i<rkey->cnt; i++){
    cmp=strcmp( *(str1+*(rkey->fldNo+i)), *(str2+*(rkey->fldNo+i)) );
               /* データの値         -kの項目オプション */
    if(cmp!=0) return(cmp);
  }
  return(cmp);
}

int rngKeyCmp(char **str, struct RangeKey *rkey){
  int i;
  int cmp=0;

  for(i=0; i<rkey->cnt; i++){
    if( MssIsNull(*(str+*(rkey->fldNo+i))) ) return(1);
    cmp=strcmp( *(rkey->str+i), *(str+*(rkey->fldNo+i)) );
               /* データの値         -kの項目オプション */
    if(cmp!=0) return(cmp);
  }
  return(cmp);
}

/**
 * 与えられたレコード(pnt)が、範囲キー(rkey)内にあるかどうかチェックする
 * 範囲内なら1,そうでなければ０を返す。
 * データがNULLなら０を返す。
 */
int inRange(char **pnt,struct RangeKey *rkey){
  int i;
  int cmp;
  int cmpFrom;
  int cmpTo;
  
  /*範囲項目以外がunmatchなら0を返す*/
  for(i=0; i<rkey->cnt-1; i++){
    if( MssIsNull(*(pnt+*(rkey->fldNo+i))) ) return(0); 
    cmp=strcmp( *(rkey->str+i), *(pnt+*(rkey->fldNo+i)) );
    if(cmp!=0) return(0);
  }
  
  /*範囲項目内なら1を返す*/
  if( MssIsNull(*(pnt+*(rkey->fldNo+i))) ) return(0); 
  cmpFrom=strcmp( rkey->from, *(pnt+*(rkey->fldNo+i)) );
  cmpTo  =strcmp( rkey->to,   *(pnt+*(rkey->fldNo+i)) );
  if( cmpFrom<=0 && cmpTo>=0){
    return(1);
  }else{
    return(0);
  }
}

/**
 * データから、範囲キーの先頭位置を返す
 */ 
int bSearch(struct RangeKey *rkey,struct mssFPR *fp,int fldCnt,int recCnt,int datTop,int recLen){
  
  struct mssFldRec    *fr1;  /*項目-行バッファ構造体             */
  struct mssFldRec    *fr2;  /*項目-行バッファ構造体             */
  int l=0;
  int r=recCnt-1;
  int x;
  int cmp;
  char *tmp;

  fr1 =mssInitFldRec(fldCnt);
  fr2 =mssInitFldRec(fldCnt);
  
  while(r>=l){
    x=(l+r)/2;
    mssReadRandFldRec(fp,fr1,x,datTop,recLen);
    tmp=fp->curPnt; /* 追加 2004/10/31 */
    mssGV.inCnt++;
    cmp=rngKeyCmp(fr1->pnt,rkey);
         
         /* v<x */ 
         if(cmp<0) r=x-1;
         /* v>x */ 
    else if(cmp>0) l=x+1;
         /* v=x */
    else          {
      if(x==0){
        mssFree(fp->curPnt); /* 追加 2004/10/31 */
        mssFreeFldRec(fr1);  /* 追加 2004/10/31 */
        mssFreeFldRec(fr2);  /* 追加 2004/10/31 */
        return(x);
      }
      mssReadRandFldRec(fp,fr2,x-1,datTop,recLen);
      if(0!=keyCmp(fr1->pnt, fr2->pnt, rkey)){
        mssFree(fp->curPnt); /* 追加 2004/10/31 */
        mssFree(tmp);        /* 追加 2004/10/31 */
        mssFreeFldRec(fr1);
        mssFreeFldRec(fr2);
        return(x);
      }else{
        r=x-1;
        mssFree(fp->curPnt); /* 追加 2004/10/31 */
      }
    }
    mssFree(tmp); /* 追加 2004/10/31 */
  }
  mssFreeFldRec(fr1);
  mssFreeFldRec(fr2);
  return(l);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    1,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* 検索文字列リスト                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSRL optVAL={
    OSRL,   /* オプションタイプ                                             */
    "v",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト                                                   */
    100,    /*要素(コロン区切)の最大数                                      */
    MssFieldMaxCnt,/*要素内での値(カンマ区切)の最大数                       */
    1,      /*値の最小文字数                                                */
    MssFieldMaxLen,/*値の最大文字数                                         */
    1,      /*範囲指定可能フラグ                                            */
    VALT,   /* このオプションのタイトル(Helpで表示)                         */
    VALC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optVAL,&optINF,&optOTF,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader    *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR       *fpr; /*入力ファイル構造体                */
  struct mssFPW       *fpw; /*出力ファイル構造体                */
  struct mssFldRec    *fr;  /*項目-行バッファ構造体             */

  int recLen;     /*レコード長*/
  int recCnt;     /*レコード数*/
  int datTop;     /*データ本体の先頭からの位置*/
  int recNum;     /*検索結果としてのレコード番号*/
  /*int flstat;*/     /*ファイルロックのステータス*/

  struct RangeKey *rkey;
  int            rkeyCnt;
  int             *fldNo;

  int i,j;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPU(optINF.str,16);     /* 入力ファイルオープン                  */

  /*ファイルロック*/
  /*
  flstat=flock( fileno(fpr->fp), LOCK_SH);
  if(flstat!=0){
    mssShowErrMsg("cannot lock the file");
    exit(mssErrorNoDefault);
  }
  */

  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
    
/*mssShowOption(opt);*/                                                       
    
  /*範囲が最後の要素以外はエラー*/
  for(i=0; i<optVAL.cnt; i++){
    for(j=0; j<*(optVAL.valCnt+i)-1; j++){                                  
      if( *(*(optVAL.to+i)+j) != NULL ){
        mssShowErrMsg("range can specify only at the last element on -v");  
        exit(mssErrorNoDefault);
      }     
    }
  } 
            
  /*検索値のセット*/
  fldNo=mssMalloc(sizeof(int)*optKEY.cnt,"xtbsselstr");
  for(i=0; i<optKEY.cnt; i++){
    *(fldNo+i)=MssFlds2num(optKEY.flds,i);
  }
  rkeyCnt=optVAL.cnt;
  rkey=mssMalloc(sizeof(struct RangeKey)*rkeyCnt,"xtbsselstr");
  for(i=0; i<optVAL.cnt; i++){
    (rkey+i)->fldNo =fldNo;
    (rkey+i)->cnt   =*(optVAL.valCnt+i);                                    
    (rkey+i)->str   =*(optVAL.from+i);
    (rkey+i)->from  =*(*(optVAL.from+i)+(rkey+i)->cnt-1);                   
    (rkey+i)->to    =*(*(optVAL.to  +i)+(rkey+i)->cnt-1);                   
    if((rkey+i)->to == NULL){
      (rkey+i)->to  = (rkey+i)->from;
    }
  }

  /*キー順のチェック*/
  for(i=0; i<optKEY.flds->cnt; i++){                                          
    if(i+1 != MssFlds2priority(hdi->flds,MssFlds2num(optKEY.flds,i))  ){    
      mssShowErrMsg("key field(s) on -k mismatch with key field(s) on input data");
      exit(mssErrorNoDefault);
    }else if( 1==MssFlds2revFlg(hdi->flds,MssFlds2num(optKEY.flds,i)) ||      
              1==MssFlds2numFlg(hdi->flds,MssFlds2num(optKEY.flds,i)) ){
      mssShowErrMsg("key field(s) on input data must not be sorted by numeric or reverse order");     
      exit(mssErrorNoDefault);
    }
  }

  /*レコードの長さを求める*/
  recLen=0;
  for(i=0; i<hdi->flds->cnt; i++){
    if( MssFlds2length(hdi->flds,i)==0) {
      mssShowErrMsg("input data is not fixed lenght format");
      exit(mssErrorNoDefault);
    }
    recLen += MssFlds2length(hdi->flds,i);
    recLen++; /*デリミタと改行分*/
  }

  /*データの先頭位置をセット*/
  datTop=fpr->chrCnt;

  /*データ行数のセット*/
  recCnt=hdi->recCnt;
  if(recCnt==-1) {
    mssShowErrMsg("there is no information of records count");
    exit(mssErrorNoDefault);
  }

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/
  hdo=mssInitCpyHeader(hdi);

  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*ソート順序は崩れるため、ソート情報をクリア*/
  mssClearFieldsSort(hdo->flds);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,0,0);
  mssWriteHeader(hdo, fpw);
  
/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  fr =mssInitFldRec(hdi->flds->cnt);
  /* -v の要素数だけ繰り返し処理*/
  for(i=0; i<rkeyCnt; i++){
    recNum=bSearch(rkey+i,fpr,hdi->flds->cnt,recCnt,datTop,recLen);
    while(1){
      if(recNum>=recCnt) break;
      mssReadRandFldRec(fpr,fr,recNum,datTop,recLen);
      mssGV.inCnt++;
      if(!inRange(fr->pnt,rkey+i)){
        mssFree(fpr->curPnt); /* 追加 2004/10/31 */
        break;
      }

      /*出力処理*/
      mssWriteFld(fr->pnt, fr->fldCnt, "\n", fpw);
      mssGV.outCnt++;
      recNum++;
      mssFree(fpr->curPnt); /* 追加 2004/10/31 */
    }
  }
  /* mssFree(fpr->curPnt); */
  mssFreeFldRec(fr);
  mssFree(fldNo);
  mssFree(rkey);

  /*ファイルアンロック*/
  /*
  flock( fileno(fpr->fp), LOCK_UN);
  */

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* フッターの出力             */
  mssCloseFPU(fpr);       /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);       /* 出力ファイルのクローズ     */
  mssFreeHeader(hdi);     /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);     /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);     /* オプション領域開放         */
  mssShowEndMsg();        /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);              /* to avoid warning message   */
}
