/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/* 0.2 : -fオプション追加 2003/08/18                                          */
/* 0.3 : パラメータによる固定長値取得に関するバグ修正 2004/01/24              */
/* 0.4 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtfixlenHelp.h>
struct mssComHelp comHelp={
  "xtfixlen",     /* コマンド名       */
  "0.4",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
    KEYT,   /* このオプションのタイトル(Helpで表示)                         */
    KEYC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 対象項目                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* オプションタイプ                                             */
    "f",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    0,      /* 正規表現を許可するかどうか(0:不可,1:可)                      */
    0,      /* 新項目名を指定できるかどうか(0:不可,1:可)                    */
    NULL,   /* 項目オプション(%以下)で指定可能な文字                        */
            /* ex) 指定不可の場合はNULL, "nr": "-f 項目名%rn"の指定可能     */
    FLDT,   /* このオプションのタイトル(Helpで表示)                         */
    FLDC,   /* このオプションのコメント(Helpで表示)                         */
    FLDF    /* フラグについての説明(Helpで表示)複数の場合はカンマで区切る   */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* オプションタイプ                                             */
    "t",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    TXTT,   /* このオプションのタイトル(Helpで表示)                         */
    TXTC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* ワークファイル用ディレクトリ名                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* オプションタイプ                                             */
    "T",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    MssTempDir, /* デフォルト                                               */
    1,      /* 文字列の最小長                                               */
    MssFileNameMaxLen,  /* 文字列の最大長                                   */
    TMPT,   /* このオプションのタイトル(Helpで表示)                         */
    TMPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* 変数宣言＆定義                                                             */
/*============================================================================*/
  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssHeader *hdo; /*出力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体                */
  struct mssFPW    *fpw; /*出力ファイル構造体                */
  struct mssFldRec *fr;  /*項目-行バッファ構造体             */
  struct mssFields *sf;  /*ソート項目構造体                  */

  int recCnt;
  int *fixFldLenOpt; /*-fで指定された項目長*/
  int *fixFldLenDat; /*データから取得する項目長*/
  int *fixFldLen;    /*最終的に決定される項目長*/
  char *str;
  int   len;
  int   padLen;
  int i,j;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */
  mssSetOptFld(&optFLD, hdi);        /* -f 項目をヘッダー項目に関連づける     */
  mssSetOptKey(&optKEY, hdi);        /* -k 項目をヘッダー項目に関連づける     */
            
  /*ソート項目の作成*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k 項目をソート項目としてセット    */
  mssSetFieldsSortPriority(sf);         /* ソート優先順位番号を登録順にふる   */
    
/*mssShowFields(sf);*/                                                        
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*レコード数のカウント                                                        */
/*----------------------------------------------------------------------------*/
  /*ソート済でもソートしてオープン*/
  fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);
  recCnt=fpr->sd->recCnt;

/*----------------------------------------------------------------------------*/
/* -f で指定された項目長のセット                                              */
/*----------------------------------------------------------------------------*/
  fixFldLenOpt=mssCalloc(sizeof(int)*hdi->flds->cnt,"fixlen");
  if(optFLD.set){
    for(i=0; i<optFLD.cnt; i++){
      if( *(optFLD.fldOpt+i)!=NULL ){
        *(fixFldLenOpt+MssFlds2num(optFLD.flds,i))=atoi(*(optFLD.fldOpt+i));
      }
    }
  }

/*----------------------------------------------------------------------------*/
/*-f で指定されていない各項目長の計算                                         */
/*-fで指定された項目長を超えるデータのチェック                                */
/*----------------------------------------------------------------------------*/
  fixFldLenDat=mssCalloc(sizeof(int)*hdi->flds->cnt,"fixlen");
  fr=mssInitFldRec(hdi->flds->cnt);
  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;
    for(i=0; i<hdi->flds->cnt; i++){
      len=strlen(*(fr->pnt+MssFlds2num(hdi->flds,i)));

      /* -f で指定されていない項目(項目長の設定&更新)*/
      if( *(fixFldLenOpt+i) == 0 ){
        if( len>*(fixFldLenDat+i) ){
          *(fixFldLenDat+i)=len;
        }

      /* -f で指定されている項目(項目長チェック)*/
      }else{
        if( len>*(fixFldLenOpt+i) ){
          mssShowErrMsg("length of field [%s] in line %d exceeds specified length [%d]",MssFlds2name(hdi->flds,i),mssGV.inCnt,*(fixFldLenOpt+i));
          mssEnd(mssErrorNoDefault);
        }
      }
    }
  }
  mssFreeFldRec(fr);
  mssSeekTopFPR(fpr);

  fixFldLen=mssCalloc(sizeof(int)*hdi->flds->cnt,"fixlen");
  for(i=0; i<hdi->flds->cnt; i++){
    if(*(fixFldLenOpt+i) > 0 ){
      *(fixFldLen+i)=*(fixFldLenOpt+i);
    }else if(*(fixFldLenDat+i) > 0 ){
      *(fixFldLen+i)=*(fixFldLenDat+i);
    }else{
      mssShowErrMsg("internal error in setting field length");
      mssEnd(mssErrorNoDefault);
    }
  }
  mssFree(fixFldLenOpt);
  mssFree(fixFldLenDat);

/*----------------------------------------------------------------------------*/
/*出力ヘッダーの作成と出力                                                    */
/*----------------------------------------------------------------------------*/
  /*出力ヘッダーの初期化(タイトル等のコピー)*/                                
  hdo=mssInitCpyHeader(hdi);
    
  /*入力ヘッダの全項目を追加*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*sfのソート情報を反映*/
  mssSetFieldsSort(hdo->flds,sf); 
    
  /*各項目の長さを登録*/
  for(i=0; i<hdi->flds->cnt; i++){
    mssSetFldInfoLength(*(hdo->flds->fi+i),*(fixFldLen+i));
  }

  /*レコード件数を登録*/
  mssSetHeaderRecCnt(hdo,recCnt);

  /*標準出力オープン+ヘッダーの出力*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  fr=mssInitFldRec(hdi->flds->cnt);

  while( EOF != mssReadFldRec(fpr,fr) ){
    mssGV.inCnt++;
    /*項目の書き出し*/
    for(i=0; i<hdi->flds->cnt; i++){
      str=*(fr->pnt+MssFlds2num(hdi->flds,i));
      len=strlen(str);
      padLen=*(fixFldLen+i)-len;
      for(j=0; j<padLen; j++) mssWriteStr(" ",fpw);
      mssWriteStr(str,fpw);
      if(i<hdi->flds->cnt-1) mssWriteDlm(fpw);
      else                   mssWriteRet(fpw);
    }
    mssGV.outCnt++;
  }
  mssFreeFldRec(fr);
  mssFree(fixFldLen);

/*----------------------------------------------------------------------------*/
/*フッター出力&終了処理                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);  /* フッターの出力             */
  mssCloseFPR(fpr);     /* 入力ファイルのクローズ     */
  mssCloseFPW(fpw);     /* 出力ファイルのクローズ     */
  mssFreeFields(sf);    /* ソート項目構造体の領域開放 */
  mssFreeHeader(hdi);   /* 入力ヘッダ領域開放         */
  mssFreeHeader(hdo);   /* 出力ヘッダ領域開放         */
  mssFreeOption(opt);   /* オプション領域開放         */
  mssShowEndMsg();      /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /*終了*/
  return(0);            /* to avoid warning message   */
}
