/*============================================================================*/
/* 変更履歴                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : β版新規作成 2003/06/20                                              */
/* 0.2 : -cオプション追加 2003/08/09                                          */
/* 0.3 : -nオプション追加,変数を'('で括れるように 2003/08/18                  */
/* 0.4 : メモリ確保に関するバグフィックス 2004/01/22                          */
/* 0.5 : メモリリーク修正 2004/10/31                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtformatHelp.h>
struct mssComHelp comHelp={
  "xtformat",     /* コマンド名       */
  "0.5",          /* バージョン       */
  HELPT,          /* コマンドタイトル */
  HELPS,          /* 要約             */
  HELPE,          /* 利用例           */
  HELPR,          /* 参照コマンド     */
  HELPA,          /* 作者情報         */
  HELPB,          /* バグレポート情報 */
  HELPH           /* ホームページ     */
};

extern struct mssGlobalVariables mssGV;
char *RepTarget; /*置換対象文字列*/
int RepTargetLen;
char *RepStr;    /*置換文字列*/
int RepStrLen;

struct PrefixNode {
  char chr;                 /*ノードにおける文字*/
  int  fldNo;               /*項目の番号(リーフの時にセットされる)*/
  int  cnt;                 /*ノードが持つ子供の数*/
  struct PrefixNode **next; /*次のノードへのリスト(cntの数だけある)*/
};

enum DocType {
  KEY,
  LINE,
  TXT,
  IF,
  THEN,
  ELIF,
  ELSE
};

char keyStrings[MssRecordMaxLen]={'\0'}; /*キー項目を文字列として保存*/
int keySum=0;

void prnn(char *str,int len){
  char *buf;
  if(str==NULL){
    printf("NULL");
  }else{
    buf=mssCalloc(sizeof(char)*(len+1),"prnn");
    strncpy(buf,str,len);
    printf("%s",buf);
    mssFree(buf);
  }
}

/*prefixTreeの出力(デバッグ用)*/
void prnPrefixTree(struct PrefixNode *pn,int depth){
  int i;

  for(i=0; i<depth; i++) printf(" ");
  printf("%c [%d] %d\n",pn->chr,pn->fldNo,pn->cnt);
  if(pn->cnt==0) return;

  for(i=0; i<pn->cnt; i++){
    prnPrefixTree( *(pn->next+i), depth+1 );
  }
}

/*prefixTreeの開放(トップノードは開放されない)*/
void freePrefixTree(struct PrefixNode *pn){
  int i;

  if(pn->cnt==0){
    return;
  }

  for(i=0; i<pn->cnt; i++){
    freePrefixTree( *(pn->next+i));
  }
  for(i=0; i<pn->cnt; i++){
    mssFree(*(pn->next+i));
  }
  mssFree(pn->next);
}

/*文字列repStrをprefixツリーに登録する*/
/*葉ノードにはfldNoが登録される*/
void setPrefixTree(struct PrefixNode *pn,char *repStr,int fldNo){
  struct PrefixNode *nextNode=NULL;
  int i;

  /*置換文字列の終端に達していれば環境変数値をセットしてリターン*/
  if(*repStr=='\0'){
    if(pn->fldNo!=-1) return; /*既に登録済ということは同じ文字列ということ*/
    pn->fldNo=fldNo;
    return;
  }

  /*次のノードを検索*/
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == *repStr ){
      nextNode=*(pn->next+i);
      break;
    }
  }

  if( nextNode==NULL ){
    /*次のノードを作成*/
    pn->next=mssRealloc(pn->next,sizeof(struct PrefixNode *)*(pn->cnt+1),"setPT");
    nextNode=*(pn->next+pn->cnt)=mssCalloc(sizeof(struct PrefixNode),"newPN");
    pn->cnt++;
    nextNode->fldNo=-1;

    /*ノードの文字をセット*/
    nextNode->chr=*repStr;
  }

  /*再帰コール*/
  setPrefixTree(nextNode,repStr+1,fldNo);
  return;
}

/*文字chrによって次のprefixノードを返す(なければNULLを返す)*/
struct PrefixNode *nextNode(struct PrefixNode *pn,char chr){
  int i;
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == chr ){
      return(*(pn->next+i));
      break;
    }
  }
  return(NULL);
}

/*----------------------------------------------------------------------------*/
/* DocNode構造体および初期化                                                  */
/*----------------------------------------------------------------------------*/
struct DocNode {
  enum   DocType type;  /*KEY,LINE,TXT,IF,ELIF,ELSE(TOPは-1)*/
  struct DocNode *parent; /*親ノードへのポインタ(TOPはNULL)*/
  struct DocNode *next; /*次のノードへのポインタ(なければNULL)*/
  int nextCnt;          /*次のノードの数*/

  int currentNo;        /*出力時のカレントノード番号(top,key,line,ifのみ有効)*/
  int no;               /*親から見て何番目のノードか*/

  char *txt;            /*TXTノードの場合、ドキュメントへのポインタ*/
  struct mssCal *cal;   /*ifノードの場合、その条件式*/
  int keyNo;            /*keyノードの場合のキー項目の数*/
};

struct DocNode *currentNode;

void initDocNode(struct DocNode *doc){
  doc->type=-1;
  doc->parent=NULL;
  doc->next=NULL;
  doc->nextCnt=0;
  doc->keyNo=0;
  doc->txt=NULL;
  doc->cal=NULL;
  doc->currentNo=0;
  doc->no=0;
}


/*----------------------------------------------------------------------------*/
/* Block構造体および初期化                                                    */
/*----------------------------------------------------------------------------*/
struct Block {
  char *top;         /*そのブロックの先頭位置*/
  char *next;        /*次のブロックの先頭位置*/
  char *tag;         /*type==TXTの時はNULL, mallocで確保*/
  enum DocType type; /*そのブロックのタイプ*/
};

void freeBlock(struct Block *block){
  if(block!=NULL){
    mssFree(block->tag);
    mssFree(block);
  }
}

/*----------------------------------------------------------------------------*/
/* strを置換条件(optREP)に従い置換し、置換後の文字列を返す                    */
/*----------------------------------------------------------------------------*/
char *replaceStr(char *str){
  char *pos;
  char *newStr;
  char *c;
  int len;

  /*十分な領域を確保(項目最大長*置換文字列最大長(10)*/
  newStr=mssMalloc(MssFieldMaxLen*11,"repStr");

  c=newStr;
  while( NULL != (pos=strstr(str,RepTarget)) ){
    strncpy(c,str,pos-str);
    c+=(pos-str);
    strncpy(c,RepStr,RepStrLen);
    c+=RepStrLen;
    str=pos+RepTargetLen;
  }
  len=strlen(str);
  strncpy(c,str,len);
  c+=len;
  *c='\0';
  return(newStr);
}

/*----------------------------------------------------------------------------*/
/* TXTNodeの出力                                                              */
/*----------------------------------------------------------------------------*/
void outTXT(struct PrefixNode *pt,char **fr,char *str,struct mssFPW *fpw){
  struct PrefixNode *pn;
  char *repStr;
  int mcnt;
  int i;
  pn=pt;
  mcnt=0; /*prefixTreeをたどっている時、最初の一致した位置を相対的にカウント*/
  while(1){

    /*終端で終了*/
    if(*str=='\0'){
      break;
    }

    /*現在の文字をprefixツリーに当てはめ、そのノードを取得*/
    pn=nextNode(pn,*str);

    /*nodeがNULLということは、一致する文字列が無かったということ*/
    if(pn==NULL){
      for(i=mcnt; i<=0; i++) mssWriteChr(*(str+i),fpw);
      mcnt=0;
      pn=pt;

    /*現在のprefixツリーnodeのfldNoが存在するということは
      マッチしたということで、置換文字列を出力*/
    }else if(pn->fldNo!=-1){

      /*置換条件が指定されていない*/
      if(RepTarget==NULL){
        mssWriteStr(*(fr+pn->fldNo),fpw);

      /*置換条件が指定されている*/
      }else{
        repStr=replaceStr(*(fr+pn->fldNo));
        mssWriteStr(repStr,fpw);
        mssFree(repStr);
      }
      pn=pt;
      mcnt=0;

    /*上記の条件以外ということは、途中までマッチ中であるということ*/
    }else{
      mcnt--;
    }
    str++;
  }
}

/*----------------------------------------------------------------------------*/
/* 現在のノードの以下の出力可能なノードを出力する                             */
/* until: 0-最後まで, 1-KEY,LINEまで, 2-LINEまで                              */
/*----------------------------------------------------------------------------*/
struct DocNode *outNode(
  struct DocNode *doc, char **fr,
  struct PrefixNode *pt,struct mssFPW *fpw){
  MssValue rsl;
  int sel;

  /*テキストノードは出力して親に戻るだけ*/
  if(doc->type == TXT){
    outTXT(pt,fr,doc->txt,fpw);
    doc->parent->currentNo++;
    return(doc->parent);
  } 

  /*これ以上子ノードがなければ親に戻る*/
  if(doc->currentNo>=doc->nextCnt) {
    doc->currentNo=0;
    doc->parent->currentNo++;
    return(doc->parent);
  }

  if(doc->type==IF){
    /*始めてこのノードに到達したときは条件評価*/
    if(doc->currentNo==0){
      rsl=mssCalculate(doc->cal, fr); 
      if(rsl.nul){
        sel=0;
      }else{
        if(rsl.vType==DBL){
          sel=(int)rsl.v.d;
        }else{
          sel=atoi(rsl.v.s);
        }
      }

      /*条件が一致すればTHENノードへ*/
      /*次に帰ってくる時は、親に戻るようにcurrentNoを設定しておく*/
      if(sel){
        doc->currentNo=doc->nextCnt;
        return(doc->next+0);

      /*条件が一致しなければ次のノードにインクリメントし*/
      /*IFノードのままリターン*/
      }else{
        doc->currentNo++;
        return(doc);
      }

    /*二度目以降の訪問の時*/
    }else{
      return(doc->next+doc->currentNo);
    }
  }

  if(doc->type==ELIF){
    rsl=mssCalculate(doc->cal, fr); 
    if(rsl.nul){
      sel=0;
    }else{
      if(rsl.vType==DBL){
        sel=(int)rsl.v.d;
      }else{
        sel=atoi(rsl.v.s);
      }
    }

    /*条件が一致すれば子ノードへ*/
    /*次に帰ってくる時は、親(IF)を終れるようにcurrentNoを設定しておく*/
    if(sel==1){
      doc->parent->currentNo=doc->parent->nextCnt;
      return(doc->next+doc->currentNo);

    /*条件が一致しなければ親ノードをインクリメントし*/
    /*親に帰る*/
    }else{
      doc->parent->currentNo++;
      return(doc->parent);
    }
  }

  return(doc->next+doc->currentNo);
}


/*----------------------------------------------------------------------------*/
/* <!--key-->に対応する<!--endkey-->タグを見つける(keyのネストを考慮して)     */
/* <!--endkey-->の"<"を'\0'に置換する                                         */
/* <!--endkey-->の次の位置を返す                                              */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getEndKey(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--key-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"key ",4) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endkey-->", 9) ) {
      depth--;
      if(depth==0) break;
    }
    pnt++;
  }

  *pnt='\0';      /*ブロックの最終地点を'\0'で置換する*/
  return(pnt+13); /*次のブロック位置を返す*/
}

/*----------------------------------------------------------------------------*/
/* <!--line-->に対応する<!--endline-->タグを見つける(lineはネストしない前提)  */
/* <!--endline-->の"<"を'\0'に置換する                                        */
/* <!--endline-->の次の位置を返す                                             */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getEndLine(char *buf){
  char *pnt=buf;

  pnt=strstr(pnt,"<!--endline-->");
  if(pnt==NULL) {
    mssShowErrMsg("there is no end tag for '<!--line-->'");
    mssEnd(mssErrorNoDefault);
  }
  *pnt='\0';      /*ブロックの最終地点を'\0'で置換する*/
  return(pnt+14); /*次のブロック位置を返す*/
}

/*----------------------------------------------------------------------------*/
/* タグのないdocの終点を見つける(次に出現するタグもしくはEOFが終点            */
/* <!--***-->の"<"を'\0'に置換する,EOFなら置換無し                            */
/* <!--***-->の次の位置を返す,EOFならNULLを返す                               */
/*----------------------------------------------------------------------------*/
char *getEndTxt(char *buf){
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt!=NULL){
      if( 0==strncmp(pnt+4,"key " , 4) ||
          0==strncmp(pnt+4,"line" , 4) ||
          0==strncmp(pnt+4,"if "  , 3) ||
          0==strncmp(pnt+4,"elif ", 5) ||
          0==strncmp(pnt+4,"else" , 4) ||
          0==strncmp(pnt+4,"endif", 5) ) break;
    }else{
      break;
    }
    pnt++;
  }
  if(pnt!=NULL){
    *pnt++='\0';   /*ブロックの最終地点を'\0'で置換する*/
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* <!--if-->に対応するendタグを見つける(ifのネストを考慮して)                 */
/* endタグは、endifのいずれか                                                 */
/* <!--endタグ-->の"<"を'\0'に置換する                                        */
/* <!--endタグ-->の次の位置を返す                                             */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getEndIf(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--if-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"if ",3) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
    }
    if(depth==0) {
      if( 0==strncmp(pnt+4,"endif", 5) ){
        *pnt++='\0'; /*ブロックの最終地点を'\0'で置換する*/
        pnt=strstr(pnt,"-->");
        if(pnt==NULL) {
          mssShowErrMsg("not a complete tag");
          mssEnd(mssErrorNoDefault);
        }
        pnt+=3;
        break;
      }
    }
    pnt++;
  }
  return(pnt);
}


/*----------------------------------------------------------------------------*/
/* then or<!--elif-->に対応するendタグを見つける(ifのネストを考慮して)        */
/* endタグは、elif,else,endifのいずれか                                       */
/* <!--endタグ-->の"<"を'\0'に置換する                                        */
/* <!--endタグ-->の次の位置を返す                                             */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getEndThen(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) break;
    if( 0==strncmp(pnt+4,"if ",3) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
    }
    if(depth==1) {
      if( 0==strncmp(pnt+4,"elif ", 5) || 0==strncmp(pnt+4,"else", 4) ){
        *pnt++='\0'; /*ブロックの最終地点を'\0'で置換する*/
        break;
      }
    }
    if(depth==0) {
      if( 0==strncmp(pnt+4,"endif", 5) ){
        *pnt++='\0'; /*ブロックの最終地点を'\0'で置換する*/
        pnt=strstr(pnt,"-->");
        if(pnt==NULL) {
          mssShowErrMsg("not a complete tag");
          mssEnd(mssErrorNoDefault);
        }
        pnt+=3;
        break;
      }
    }
    pnt++;
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* <!--else-->に対応するendタグを見つける(ifのネストを考慮して)               */
/* <!--endif-->の"<"を'\0'に置換する                                          */
/* <!--endif-->の次の位置を返す                                               */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getEndElse(char *buf){

  return(NULL);
/*
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--if-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"key ",4) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
      if(depth==0) break;
    }
    pnt++;
  }
*/

}

/*----------------------------------------------------------------------------*/
/* bufから最初のブロックを抜き出す                                            */
/* <!--endif-->の"<"を'\0'に置換する                                          */
/* <!--endif-->の次の位置を返す                                               */
/* 対応するendタグがなければエラー                                            */
/*----------------------------------------------------------------------------*/
char *getNextBlock(char *buf,enum DocType type){
  char *pnt=NULL;

  switch(type){
    case KEY:
      pnt=getEndKey(buf);
      break;
    case LINE:
      pnt=getEndLine(buf);
      break;
    case TXT:
      pnt=getEndTxt(buf);
      break;
    case IF:
      pnt=getEndIf(buf);
      break;
    case THEN:
    case ELIF:
      pnt=getEndThen(buf);
      break;
    case ELSE:
      pnt=getEndElse(buf);
      break;
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* bufから最初のブロックを抜き出す。Block構造体を返す                         */
/* block->tag  = <!--***-->の文字列                                           */
/* block->type = KEY | LINE | TXT | IF | ELIF | ELSE                          */
/* block->next = 次のブロックの最初の位置"!--***-->"の先頭                    */
/* block->top  = <!--***-->"の次の位置                                        */
/*----------------------------------------------------------------------------*/
struct Block *getBlock(char *buf, struct DocNode *doc){
  struct Block *block;
  char *end;
  char repChr;

  block=mssCalloc(sizeof(struct Block),"getBlock");

  /*ブロックのタイプを設定*/
        if(0==strncmp(buf,"!--key " , 7)){
    block->type=KEY;
  }else if(0==strncmp(buf,"!--line" , 7)){
    block->type=LINE;
  }else if(0==strncmp(buf,"!--if "  , 6)){
    block->type=IF;
  }else if(0==strncmp(buf,"!--elif ", 8)){
    block->type=ELIF;
  }else if(0==strncmp(buf,"!--else" , 7)){
    block->type=ELSE;
  }else if(doc->type==IF){
    block->type=THEN;
  }else{
    block->type=TXT;
  }

  /*そのブロックの終了位置を検出し、\0に置換し、次のブロックの先頭を設定*/
  /*ブロック最後に達していればNULLとなる*/
  block->next=getNextBlock(buf,block->type);

  /*tagを文字列として取得(新しい領域確保,オリジナルは変更しない)*/
  if(block->type != TXT && block->type != THEN){
    end=strstr(buf,"-->");
    if(end==NULL){
      mssShowErrMsg("can not find closure");
      mssEnd(mssErrorNoDefault);
    }
    end+=3;
    /*tagのコピー*/
    repChr=*end;
    *end='\0';
    block->tag=mssStrdup(buf);
    *end=repChr;
    block->top=end;

    /*ブロックの先頭位置(tagの次の文字位置)*/
  }else{
    /*TXT,THENタイプの場合はtagなし*/
    block->tag=NULL;
    block->top=buf;
  }
  
  return(block);
}


int getFldNo(struct PrefixNode *pt,char *str){
  struct PrefixNode *pn;
  int fldNo;
  int mcnt;
  pn=pt;
  mcnt=0; /*prefixTreeをたどっている時、最初の一致した位置を相対的にカウント*/
  while(1){
  
    /*終端で終了*/
    if(*str=='\0'){
      fldNo=-1;
      break;
    } 
    
    /*現在の文字をprefixツリーに当てはめ、そのノードを取得*/
    pn=nextNode(pn,*str);
    
    /*nodeがNULLということは、一致する文字列が無かったということ*/
    if(pn==NULL){
      fldNo=-1;
      break;      

    /*現在のprefixツリーnodeのfldNoが存在するということは
      マッチしたということで、置換文字列を出力*/
    }else if(pn->fldNo!=-1){
      fldNo=pn->fldNo;
      break;
    }

    /*上記の条件以外ということは、途中までマッチ中であるということ*/
    str++;
  }
  return(fldNo);
}

/*----------------------------------------------------------------------------*/
/* key タグの項目名から項目名をkeyStrings(グローバル)にセットする             */
/* doc->keyNoには、これまでのKey項目の数の累積をとる                          */
/*----------------------------------------------------------------------------*/
void setKeyTag(struct DocNode *doc, char *tag,struct PrefixNode *pt){
  char **keyStr;
  int keyCnt;
  int i;
  char *end;

  /* !--key $fldname1,$fldname2-->  --> tag=="$fldname1,$fldname2" */
  tag+=7;
  end=strstr(tag,"-->");
  if(end==NULL) {
    mssShowErrMsg("can not find closure");
    mssEnd(mssErrorNoDefault);
  }
  *end='\0';


  /* $fildname の項目番号を調べセットする */
  keyStr=mssTokByChr(tag,',',&keyCnt,0);
  for(i=0;i<keyCnt;i++){ /*複数の項目を調べる(カンマ区切り)*/
    /* Key構造体用に文字列としての項目名を確保*/
    strcat(keyStrings,",");
    strcat(keyStrings,*(keyStr+i));
  }
  keySum+=keyCnt;
  doc->keyNo=keySum;
  mssFree(keyStr); /* 追加 2004/10/31 */
}

/*----------------------------------------------------------------------------*/
/* if, elif タグの項目名から計算式構造体をセットする                          */
/*----------------------------------------------------------------------------*/
void setIfTag(struct DocNode *doc, char *tag,struct mssHeader *hdi){
  char *end;

  /* !--if $fldname1="aaa"-->  --> tag==$fldname1="aaa" */
  if(doc->type==IF) tag+=6;
  else              tag+=8;
  end=strstr(tag,"-->");
  if(end==NULL) {
    mssShowErrMsg("can not find closure");
    mssEnd(mssErrorNoDefault);
  }
  *end='\0';

  /*計算式の評価*/
  doc->cal=mssCalCompile(tag,hdi);

}

/*----------------------------------------------------------------------------*/
/* 参照ファイルの構造を解析し、DocNode構造体にセットする                      */
/*----------------------------------------------------------------------------*/
void setDocTree(
  struct DocNode *doc,
  char *buf,
  struct PrefixNode *pt,
  struct mssHeader *hdi){
  struct Block *block;     /*新たに得たブロックの情報*/
  struct DocNode *curNext; /*新しく確保したDocNode(記述短縮のため)*/

  doc->nextCnt=0;
  while(1){
   /* bufから最初のブロックを抜き出す。Block構造体のセット */
    block=getBlock(buf,doc);
/*printf("==%d=%s\n",block->type,block->top); */

    /*上記で得たブロック用のDocNode構造体の確保*/
    doc->next=
      mssRealloc(doc->next,sizeof(struct DocNode)*(doc->nextCnt+1),"setDoc");
    curNext=doc->next+doc->nextCnt;
    initDocNode(curNext);
    curNext->no=doc->nextCnt; /*親から見て何番目のノードか*/
    doc->nextCnt++;
    curNext->type=block->type;

    switch(block->type){
      case KEY:
        setKeyTag(curNext,block->tag,pt);
        break;
      case LINE:
      break;
      case IF:
        setIfTag(curNext,block->tag,hdi);
        break;
      case ELIF:
        setIfTag(curNext,block->tag,hdi);
        break;
      case THEN:
      case ELSE:
        break;
      case TXT:
        curNext->txt=block->top;
      break;
    }

    /*TXTブロックの場合以外、再帰処理*/
    if(block->type!=TXT){
      setDocTree(curNext,block->top,pt,hdi);
    }

    /*次のブロックをセットし繰り返し処理*/
    buf=block->next;
    freeBlock(block);

    /*次のブロックがなければ終了*/
    if(buf==NULL) break;
  }
}


/*----------------------------------------------------------------------------*/
/* 親ノードの設定                                                             */
/*----------------------------------------------------------------------------*/
void setParent(struct DocNode *doc,struct DocNode *parent){
  int i;
  doc->parent=parent;
  for(i=0; i<doc->nextCnt; i++){
    setParent(doc->next+i,doc);
  } 
}

/*----------------------------------------------------------------------------*/
/* DocNode構造体の出力(デバッグ用)                                            */
/*----------------------------------------------------------------------------*/
void prnTxt(char *str){
  while(*str!='\0'){
    if(*str=='\n') printf("\\n");
    else           printf("%c",*str);
    str++;
  }
}

/*----------------------------------------------------------------------------*/
/* DocNode構造体の解放                                                        */
/*----------------------------------------------------------------------------*/
/* 追加 2004/10/21 */
void freeDocTree(struct DocNode *doc){
  int i;

  switch(doc->type){
    case KEY:
      break;
    case LINE:
      break;
    case TXT:
      break;
    case IF:
      mssCalFree(doc->cal);
      break;
    case ELIF:
      mssCalFree(doc->cal);
      break;
    case THEN:
      break;
    case ELSE:
      break;
  }
  if(doc->next!=NULL){
    for(i=0; i<doc->nextCnt; i++){
      freeDocTree(doc->next+i);
    }
  }
  mssFree(doc->next);
}


void prnDocTree(struct DocNode *doc, int depth){
  int i;

  for(i=0; i<depth; i++) printf("  ");
  switch(doc->type){
    case KEY:
      printf("KEY (%d) [%d]\n",doc->no,doc->keyNo);
      break;
    case LINE:
      printf("LINE (%d)\n",doc->no);
      break;
    case TXT:
      printf("TXT (%d)[",doc->no);
      prnTxt(doc->txt);
      printf("]\n");
      break;
    case IF:
      printf("IF (%d)\n",doc->no);
      /*cal_printTree(doc->cal,0);*/
      break;
    case ELIF:
      printf("ELIF (%d)\n",doc->no);
      /*cal_printTree(doc->cal,0);*/
      break;
    case THEN:
      printf("THEN (%d)\n",doc->no);
      break;
    case ELSE:
      printf("ELSE (%d)\n",doc->no);
      break;
  }
  if(doc->next==NULL) return;
  for(i=0; i<doc->nextCnt; i++){
    prnDocTree(doc->next+i,depth+1);
  }
}

void setCalReadFunc(struct DocNode *doc, struct mssFldRecDbl *frd)
{
  int i;
  if(doc->type == IF){
    /*calculationで利用する読込関数を登録*/
    mssCalReadFuncIsFRD(doc->cal,frd);
  }
  if(doc->next==NULL) return;
  for(i=0; i<doc->nextCnt; i++){
    setCalReadFunc(doc->next+i,frd);
  }
}

/*----------------------------------------------------------------------------*/
/* keyタグのキーブレイクの判定                                                */
/*----------------------------------------------------------------------------*/
int keyTagBreak(struct mssFldRecDbl *frd, MssOptKEY *optKey, struct DocNode *doc){
  int i,fn;

  /*最終行の時はキーブレーク*/
  if(frd->eof == 1) return(1);

  for(i=0; i<doc->keyNo; i++){
    fn=MssFlds2num(optKey->flds,i);
    if( 0 != strcmp(*(frd->pnt[frd->new]+fn),*(frd->pnt[frd->old]+fn)) )
       return(1);
  }
  /*上記の条件をクリアしたということはキーブレークでない*/
  /*(optKey->flds->cntが0ということは、-kの指定がないのでキーブレークでない)*/
  return(0);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* オプション宣言＆定義                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* キー項目(内部的に利用、パラメータでは指定できない                          */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* オプションタイプ                                             */
    "k",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    MssFieldMaxCnt, /* 指定可能な最大項目数                                 */
    "i",    /* 対象とする入力データのキーワード(GUIで利用)                  */
    2,      /* デフォルト(このオプションが指定されなかったときの動作を指定) */
            /* 1:全ての行を異るキー値として扱う                             */
            /* 2:全ての行を同じキー値として扱う)                            */
  };

/*----------------------------------------------------------------------------*/
/* 文字列置換リスト                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSLS optREP={
    OSLS,   /* オプションタイプ                                             */
    "c",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須, 2:XMLtableでのみ必須(txtでは無視)      */
    NULL,   /* デフォルト(文字列)                                           */
    1,      /* カンマで区切られる要素数の最大値                             */
    1,      /* 各要素の文字列長の最小値                                     */
    MssFieldMaxLen,/* 各要素の文字列長の最大値                              */
    1,      /* 1:要素にコロンを指定できる,0:不可  ex) aaaa:xxxxx            */
    REPT,   /* このオプションのタイトル(Helpで表示)                         */
    REPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 入力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* オプションタイプ                                             */
    "i",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    INFT,   /* このオプションのタイトル(Helpで表示)                         */
    INFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 置換対象ファイル                                                           */
/*----------------------------------------------------------------------------*/
  MssOptINF optREF={
    OINF,   /* オプションタイプ                                             */
    "I",    /* キーワード(複数文字は不可)                                   */
    1,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    REFT,   /* このオプションのタイトル(Helpで表示)                         */
    REFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* データがない時に出力するファイル                                           */
/*----------------------------------------------------------------------------*/
  MssOptINF optNUL={
    OINF,   /* オプションタイプ                                             */
    "n",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    1,      /* 指定可能の最大ファイル数                                     */
    0,      /*1:file not foundのエラーで終了しない 0:する                   */
    NULT,   /* このオプションのタイトル(Helpで表示)                         */
    NULC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 出力ファイル                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* オプションタイプ                                             */
    "o",    /* キーワード(複数文字は不可)                                   */
    0,      /* 0:オプション, 1:必須                                         */
    OTFT,   /* このオプションのタイトル(Helpで表示)                         */
    OTFC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* 圧縮出力                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* オプションタイプ                                             */
    "z",    /* キーワード(複数文字は不可)                                   */
    0,      /* デフォルト(基本的には0) 常にonにしたいときは1にする          */
    ZIPT,   /* このオプションのタイトル(Helpで表示)                         */
    ZIPC    /* このオプションのコメント(Helpで表示)                         */
  };

/*----------------------------------------------------------------------------*/
/* オプションをまとめる                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optREP,&optINF,&optREF,&optNUL,&optOTF,&optZIP,NULL};
  void *optInside[]={&optKEY,NULL}; /* 追加 2004/10/31 */

  struct mssHeader *hdi; /*入力ファイル用<head>タグ格納構造体*/
  struct mssFPR    *fpr; /*入力ファイル構造体*/
  struct mssFPR    *fpf; /*参照ファイル構造体*/
  struct mssFPW    *fpw; /*出力ファイル構造体*/
  /*Key           *key;*/ /*キー項目構造体*/

  struct mssFldRecDbl *frd; /*項目-キーバッファ構造体*/
  struct DocNode *doc;
  struct DocNode *keyNode;
  struct mssRec    *rec; /*行バッファ構造体*/
  struct PrefixNode *pt;
  char *buf;
  int   bufSize;
  char fldName[MssFieldNameMaxLen+10];
  int i;

/*----------------------------------------------------------------------------*/
/* 前処理                                                                     */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* シグナル処理などの初期化              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* ヘルプ                                */
  mssSetOption(opt,argc,argv);       /* コマンドオプションの設定              */
  fpr=mssOpenFPR(optINF.str,4);      /* 入力ファイルオープン                  */
  hdi=mssReadHeader(fpr);            /* ヘッダの読み込み                      */

  if(optREP.set){
     RepTarget=*optREP.strList;
     RepTargetLen=strlen(*optREP.strList);
  }else{
     RepTarget=NULL;
  }
  if(optREP.set){
     RepStr=*optREP.colList;
     RepStrLen=strlen(*optREP.colList);
  }else{
     RepStr=NULL;
  }

/*----------------------------------------------------------------------------*/
/* 項目名を変数名としてprefixTreeにセット                                     */
/* リーフには項目番号をセット                                                 */
/*----------------------------------------------------------------------------*/
  pt=mssCalloc(sizeof(struct PrefixNode),"newPN");
  pt->fldNo=-1;
  for(i=0; i<hdi->flds->cnt; i++){

    /*置換対象文字列 ex. $abc */
    strcpy(fldName,"$");
    strcat(fldName,MssFlds2name(hdi->flds,i));

    /*prefix treeに登録*/
    setPrefixTree(pt,fldName,i);

    /*置換対象文字列 ex. $(abc) */
    strcpy(fldName,"$(");
    strcat(fldName,MssFlds2name(hdi->flds,i));
    strcat(fldName,")");

    /*prefix treeに登録*/
    setPrefixTree(pt,fldName,i);
  }
/* prnPrefixTree(pt,0); */

/*----------------------------------------------------------------------------*/
/* 置換ファイルを読み込む                                                     */
/* -Kの値で囲まれたブロック                                                   */
/*                                                                            */
/* <html>                                                                     */
/*   <!--key-->                                                               */
/*     <table>aaaaa $date bbb                                                 */
/*     <!--line-->                                                            */
/*        <td>$user</td><td>$time</td>                                        */
/*     <!--line-->                                                            */
/*     aaaaa $date bbb                                                        */
/*     </table>                                                               */
/*   <!--key-->                                                               */
/* </html>                                                                    */
/*                                                                            */
/* repTxtHead 一つ目の<!--key-->までのブロック                                */
/* repTxtKeyH 一つ目の<!--key-->から一つ目の<!--line-->までのブロック         */
/* repTxtLine 一つ目の<!--line-->から二つ目の<!--line-->までのブロック        */
/* repTxtKeyT 二つ目の<!--line-->から二つ目の<!--key-->までのブロック         */
/* repTxtTail 二つ目の<!--key-->以降のブロック                                */
/*----------------------------------------------------------------------------*/
  /* 参照ファイルをメモリ(buf)に読み込む("\n"込) */
  fpf=mssOpenFPR(optREF.str,4);
  rec=mssInitRec();
  buf=mssCalloc(1,"buf");
  bufSize=1;
  while(EOF != mssReadRec(fpf,rec)){
    bufSize+=rec->chrCnt;
    buf=mssRealloc(buf,sizeof(char)*bufSize,"buf");
    strcat(buf,rec->pnt);
    strcat(buf,"\n");
  }
  mssFreeRec(rec);
  mssCloseFPR(fpf);

  doc=mssMalloc(sizeof(struct DocNode),"iniDoc");
  initDocNode(doc);
  setDocTree(doc,buf,pt,hdi);
  setParent(doc,NULL);
/*  prnDocTree(doc,0); */

  /*---------------------------------------------*/
  /* キー項目名のパラメータとしての文字列作成    */
  /* ",$week,$date,$(store)" ->"week,date,store" */
  /*---------------------------------------------*/
  {
    char *to=keyStrings;
    char *fr=keyStrings;
    if(*fr==',')fr++;
    while(*fr!='\0'){
      if( *fr=='$' || *fr=='(' || *fr==')' ) {
        fr++;
        continue;
      }
      *to=*fr;
      fr++;to++;
    }
    *to=*fr;
  }

  /* optKeyをここで強制定義する*/
  optInside[0]=&optKEY; optInside[1]=NULL; /* 追加 2004/10/31 */
  if(keyStrings[0]=='\0'){
    optKEY.type=OKEY;
    optKEY.set=0;
    optKEY.str=NULL;
    optKEY.cnt=0;
    optKEY.nam=NULL;
    optKEY.diffSame=1;
  }else{
    optKEY.type=OKEY;
    optKEY.set=1;
    optKEY.str=mssStrdup(keyStrings);
    optKEY.cnt=0;
    optKEY.nam=mssTokByChr(keyStrings,',',&optKEY.cnt,1);
    optKEY.diffSame=0;
  }
  mssSetOptKey(&optKEY, hdi); /* -k 項目をヘッダー項目に関連づける     */

  /* 出力ファイルオープン */
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

/*----------------------------------------------------------------------------*/
/*メインルーチン                                                              */
/*----------------------------------------------------------------------------*/
  frd=mssInitFRD(hdi->flds->cnt); /*FRD構造体の初期化*/

  setCalReadFunc(doc, frd);

  currentNode=doc; /*カレントノードの設定(グローバル変数)*/
  while( EOF!=mssReadFRD(fpr,frd) ){

    /*最初の一行だけ*/
    if(mssGV.inCnt==0){
      /*lineタグまで出力*/
      while(currentNode->type!=LINE){
        currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      }
      mssGV.outCnt++;
    }
    /*キーブレイク時の処理*/
    if(mssKeyBreak(frd, &optKEY)){
      while(1){
        if(currentNode->parent->type!=KEY) break;
        if(!keyTagBreak(frd, &optKEY, currentNode->parent)) break;
        currentNode=currentNode->parent;
        keyNode=currentNode;
        keyNode->currentNo++;
        while(1) {
          currentNode=outNode(currentNode,frd->pnt[frd->old],pt,fpw);
          mssGV.outCnt++;
          if(currentNode==keyNode &&
             currentNode->currentNo>=currentNode->nextCnt) break;
        }
        currentNode->currentNo=0;
      }

      if(frd->eof) break;

      /*lineタグまで出力*/
      while(currentNode->type!=LINE){
        currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      }
      mssGV.outCnt++;
    }

    mssGV.inCnt++;

    /*通常行の処理*/
    while(1) {
      currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      mssGV.outCnt++;
      if(currentNode->type==LINE &&
         currentNode->currentNo>=currentNode->nextCnt) break;
    }
    currentNode->currentNo=0;
  }

  /*データが一件もない&-nが指定されている->ファイルの内容を出力*/
  if(mssGV.inCnt==0){
    if(optNUL.set){
      fpf=mssOpenFPR(optNUL.str,4);
      rec=mssInitRec();
      while(EOF != mssReadRec(fpf,rec)){
        mssWriteStr(rec->pnt,fpw);
        mssWriteRet(fpw);
        mssGV.outCnt++;
      }
      mssFreeRec(rec);
      mssCloseFPR(fpf);
    }
  /*最後のブロックの内容を出力*/
  } else {
    doc->currentNo++;
    currentNode=doc;
    while(1) {
      currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      mssGV.outCnt++;
      if(currentNode->type==-1 &&
         currentNode->currentNo>=currentNode->nextCnt) break;
    }
  }

  freeDocTree(doc); /* 追加 2004/10/31 */
  mssFree(doc); /* 追加 2004/10/31 */
  mssFree(buf); /* 追加 2004/10/31 */
  mssFreeFRD(frd);
  freePrefixTree(pt);
  mssFree(pt);

/*----------------------------------------------------------------------------*/
/*終了処理                                                                    */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);     /*入力ファイルのクローズ*/
  mssFreeHeader(hdi);   /*入力ヘッダ領域開放          */
  mssCloseFPW(fpw);     /*出力ファイルのクローズ*/
  mssFreeOption(opt);   /*オプション領域開放*/
  mssFreeOption(optInside); /*オプション領域開放*/
  mssShowEndMsg();      /* 完了メッセージ             */
  mssEnd(mssExitSuccess); /* 終了                       */
  return(0);            /* to avoid warning message   */
}

