
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "瀕出サブストリングの件数"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "キー項目名リスト"
#define KEYC "部分シーケンスをカウントする単位となる項目名リスト"

/*-u*/
#define UNTT "シーケンス単位項目名リスト"
#define UNTC "一つのシーケンスの単位となる項目名リスト"

/*-f*/
#define FLDT "シーケンスを表す項目名"
#define FLDC "ここで指定した項目をシーケンスとみなす"
#define FLDF NULL

/*-s*/
#define SRTT "並べ換える項目名リスト"
#define SRTC "キー項目名で指定した単位行の中で、シーケンスの順番を決めるための項目名を指定する"
#define SRTF "数値順,逆順"

/*-c*/
#define CNTT "件数"
#define CNTC "このパラメータによって、出力する件数を制限できる。"

/*-p*/
#define PCTT "パーセント"
#define PCTC "このパラメータによって、出力する件数を、最瀕出のシーケンスの件数に対する割合によって制限できる。デフォルトは 10 である。"

/*-l*/
#define LENT "シーケンスの長さ範囲"
#define LENC "このパラメータによって、出力するシーケンスの長さを制限できる。デフォルトは 2_5 である。最小値は:1,最大値は50。"

/*-Q*/
#define SSQT "subsequenceの件数をもとめる"
#define SSQC "substringに代えてsubsequenceの出現件数を求める"

/*-x*/
#define XMLT "XMLによる出力"
#define XMLC "出力をXMLtableでなくXMLの形式でおこなう。"

/*-a*/
#define FNMT C_FNMT
#define FNMC C_FNMC

/*-q*/
#define SEQT C_SEQT
#define SEQC C_SEQC

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "-kで指定した項目の値が同じ行について、-fで指定した項目の値をシーケンスとしてとらえ、その部分シーケンスの件数をカウントする。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtcntsubstr -k 顧客,日付 -s 時間 -f 店 -idat.trn -Idat.tst\n\
xtcntsubstr -k 顧客,日付 -s 時間 -f 店 -c 1000 -idat.trn -Idat.tst\n\
xtcntsubstr -k 顧客,日付 -s 時間 -f 店 -l 10_30 -idat.trn -Idat.tst\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR ""

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
