
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "XMLtable→graphML変換"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define NKYT "ノードファイル上のグラフID"
#define NKYC "ここで指定した項目と-Kで指定されたエッジファイルの項目が同じ行を１つのグラフとしてみなす"

/*-K*/
#define EKYT "エッジファイル上のグラフID"
#define EKYC "ここで指定した項目と-kで指定されたノードファイルの項目が同じ行を１つのグラフとしてみなす"

/*-v*/
#define NIDT "ノードID項目名リスト"
#define NIDC "このノードIDとエッジファイル上の-b,-e(開始ノード,終了ノード)の項目とマッチングされる"
#define NIDF NULL

/*-f*/
#define NATT "ノード属性項目名リスト"
#define NATC "%nで数値属性をあらわす.デフォルトはカテゴリ属性"
#define NATF "数値属性"

/*-b*/
#define EBGT "エッジの開始ノードID項目名リスト"
#define EBGC "このノードIDとノードファイル上の-v(ノードID)の項目とマッチングされる"
#define EBGF NULL

/*-e*/
#define EEDT "エッジの終了ノードID項目名リスト"
#define EEDC "このノードIDとノードファイル上の-v(ノードID)の項目とマッチングされる"
#define EEDF NULL

/*-F*/
#define EATT "エッジ属性項目名リスト"
#define EATC "%nで数値属性をあらわす.デフォルトはカテゴリ属性"
#define EATF "数値属性"

/*-d*/
#define DIRT "directionを示す項目名"
#define DIRC "0:undirected,1:directed"
#define DIRF NULL

/*-D*/
#define DFGT "全てをdirected graphにするフラグ"
#define DFGC "このオプションと-dは排他的である"

/*-W*/
#define WOTT "-vで指定されたノードIDをgraphLabelに含めない"
#define WOTC "参照ファイル名を指定する"

/*-i*/
#define NIFT "ノードファイル"
#define NIFC "ノードファイル"

/*-i*/
#define EIFT "エッジファイル"
#define EIFC "エッジファイル"

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*-cr*/
#define CPYT "コピーライト"
#define CPYC "Header要素のcopyright属性"

/*-desc*/
#define DSCT "コメント"
#define DSCC "Header要素のdescription属性"

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "XMLtableで表現されたノードファイルとエッジファイルを、GraphMLに変換する。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xt2gml -v ノード -i node.xt -b 開始ノード -e 終了ノード -I edge.xt -o rsl.gml\n\
xt2gml -k グラフID -v ノード -f 属性1,属性2%n -i node.xt -b 開始ノード -e 終了ノード -F エッジ属性1%n,エッジ属性2 -I edge.xt -o rsl.gml\n\
xt2gml -v ノード -i node.xt -b 開始ノード -e 終了ノード -d 方向 -I edge.xt -o rsl.gml\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "agm"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
