
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "二分探索による更新"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "キー項目名リスト"
#define KEYC "検索対象項目：項目名%検索値"
#define KEYF NULL

/*-v*/
#define VALT "検索値リスト"
#define VALC "値a,値b:値c,値c~値d"

/*-f*/
#define FLDT "項目名リスト"
#define FLDC "更新対象項目：項目名%更新値"
#define FLDF NULL

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "-kで指定した項目と値で対象行を検索し、-fで指定した項目と値にて更新をおこなう。入力データはあらかじめxtfixlenにより固定長変換されている必要がある。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtbsupdate -k 商品 -v 菓子 -f 在庫数%4 -i dat.xt\n\
xtbsupdate -k 商品,味 -v 菓子:塩 -f 在庫数%4,注文数%5 -i dat.xt\n\
xtbsupdate -k 日付,時間 -v 20030819:100000~110000 -f 予約%1 -i dat.xt\n\
xtbsupdate -k 日付,時間 -v 20030819:100000~110000,20030820 -f 予約%1 -i dat.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtfixlen,xtbsselstr"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
