/**
 * # CHAPTER #
 * ============================================================================
 * 集計(aggregate)処理関連のヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssValue.h>
#include <musashi/mssHeader.h>
#include <musashi/mssInput.h>
#include <musashi/mssOutput.h>
#include <stdio.h>

#ifndef _MSSPREAGG_H
#define _MSSPREAGG_H

/**
 * # DEFINE #
 * マージソート集計を行う際に、何個までのファイルを同時に併合させるか
 */
#define PWayA 25

/**
 * # DEFINE #
 * 赤黒木で使用するメモリ量上限値
 */
#define MaxMemA 2048000


/**
 * # ENUM #
 *集計方法の列挙体
 */
enum MssAggType {
  aggSUM,  /*合計*/
  aggAVG,  /*平均*/
  aggAVG2, /*併合時の平均*/
  aggCNT,  /*件数*/
  aggMAX,  /*最大値*/
  aggMIN,  /*最小値*/
  aggSTD,  /*標準偏差 s=sqrt{(1/(n-1))*((x1-x)^2+(x2-x)^2+...+(xn-x)^2)} */
  aggSTDP, /*標準偏差 s=sqrt{(1/n)*((x1-x)^2+(x2-x)^2+...+(xn-x)^2)} */
  aggVAR,  /*分散     s^2=(1/(n-1))*((x1-x)^2+(x2-x)^2+...+(xn-x)^2) */
  aggVARP, /*分散     s^2=(1/n)*((x1-x)^2+(x2-x)^2+...+(xn-x)^2) */
};

/**
 * # STRUCT #
 * 赤黒木で集計するための構造体
 */
struct mssAggDat {
  int             fldCnt;                /*データ一行の項目数*/
  MssOptKEY *        optKey;                /*キー項目オプション*/
  MssOptFLD *        optFld;                /*項目オプション*/
  enum MssAggType aggType;               /*0:シーケンシャル集計,1:RBtree*/

  MssValue *         val;                   /*読みこんだ文字項目保管用(一時的)*/
  int             valCnt;                /*その数(fldCnt*利用するval数)*/
  int             procType;              /*0:シーケンシャル集計,1:RBtree*/

  /* シーケンシャル集計用関連*/
  MssValue *         aggVal;                /*集計された値の保管用(一時的)*/

  /* 内部sort+集計用関連*/
  struct RBAGnode *rb;                    /*赤黒木プライオリティキュー*/
  struct mssFPR   *iFile[PWayA];          /*入力ワークファイルポインタ(text部)*/
  FILE            *vFile[PWayA];          /*入力ワークファイルポインタ(val部)*/
  char             prefixTxt[MssFileNameMaxLen];/*一時Fileのプレフィックス(text部)*/
  char             prefixVal[MssFileNameMaxLen];/*一時Fileのプレフィックス(val部)*/
  struct mssFldRec *fr[PWayA];         /*入力ワークファイル読み込みバッファ*/
  char            *tmpDir;                /*ワークファイルのパス*/
  int              iStart;                /*開始入力ファイル番号*/
  int              iEnd;                  /*終了入力ファイル番号*/
  int             *inCnt;                 /*入力データのカウンタへのポインタ*/
};

/**
 * # STRUCT #
 * 赤黒木のノードで利用するキー構造体
 */
struct RBAGkey {
  char    *str;    //項目が\0で区切られた一レコード
  char   **fld;    //strの各項目へのポインタ
  MssValue   *val;   //値を二次元配列で持つための変数
  int     *bkt;    //集計されたバケットの番号
  int      bktCnt; //その時までに集計されたバケットの数
};
  
/**
 * # STRUCT #
 * 赤黒木のノード構造体
 */
struct RBAGnode {
  struct RBAGkey *key;
  struct RBAGnode *parent, *left, *right;
  int    rank;
};

/**
 * # PROTOTYPE # 
 */
struct mssAggDat *	mssInitAggDat(int fldCnt, MssOptKEY *optKey, MssOptFLD *optFld, char *aggTypeChr, char *tmpDir, int *inCnt);
void			mssFreeAggDat(struct mssAggDat *ad);
void			mssPreAgg(struct mssAggDat *ad, struct mssFPR *fpr);
void			mssClearAggVal(MssValue *val, enum MssAggType aggType, int fc);
void			mssCalAggVal(MssValue *val, enum MssAggType aggType, MssValue *val2);
void			mssWriteAggFld(char **fld, MssValue *val, enum MssAggType aggType, struct mssFPW *fpw);
int			mssReadWriteAgg(struct mssAggDat *ad, struct mssFPW *fpw);
void			mssSetAggVal(MssValue *val, char **str);

#endif /*_PREAGG_H*/
