/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIで用いられる基本的な関数用のヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssConfig.h>

#include <stdlib.h>
#include <time.h>

#ifndef __MSSBASE_H
#define __MSSBASE_H 1


/**
 * # DEFINE #
 * 正常終了時辺値
 */
#define mssExitSuccess EXIT_SUCCESS /*正常終了時辺値*/

/**
 * # DEFINE #
 *デフォルトのエラー終了番号
 */
#define mssErrorNoDefault 1

/**
 * # DEFINE #
 * 整数乱数最大値
 */
#define mssRandMax 2147483647

/**
 * # STRUCT #
 * コマンドヘルプの型
 */
struct mssComHelp {
  char *name;      /*コマンド名*/
  char *version;   /*バージョン*/
  char *title;     /*タイトル*/
  char *summary;   /*要約*/
  char *example;   /*利用例*/
  char *reference; /*参照コマンド*/
  char *author;    /*作者*/
  char *bugReport; /*バグレポート先E-mail*/
  char *homepage;  /*コマンドに関するHP*/
};

/**
 * # STRUCT #
 * 動的メモリ確保のデバッグ用情報
 */
struct mssAllocInf {
  int func;  /*0:free,1:calloc,2:malloc,3:realloc,4:reallocLim,5:strdup*/
  void *add; /*アドレス*/
  int cnt;   /*AllocCnt*/
  int size;
  char msg[256]; /*メッセージ*/
  int refNo; /*allocに対するfree,freeに対するallocの番号*/
};


/**
 * # STRUCT #
 * MUSASHIが利用するグローバル変数構造体(base.cにて定義)
 */
struct mssGlobalVariables {
  struct mssComHelp *comHelp; /*コマンドヘルプ*/
  int    inCnt;    /*データ入力行数*/
  int    outCnt;   /*データ出力行数*/
  int    keyNo;    /*現在処理中のキー番号*/
  int    keyCnt;   /*現在処理中のキーの行数*/
  int    keyLine;  /*現在処理中のキーのなかでの行番号*/
                   /*上記の各種件数は、APIでは一切更新しないので、各コマンドの
                     プログラムの中で設定する。
                     inCnt,outCntは、コマンド終了メッセージ(mssShowEndMsg関数)
                     の一部として出力される。*/
  int    inFldCnt; /*入力データの項目数(cal_prior関数で設定)*/
  int    quiet;    /*メッセージ出力をしないフラグ(mssInit,setOption関数で設定)*/
  int    argc;     /*コマンドライン引数(mssInit関数で設定)*/
  char **argv;     /*コマンドライン引数(mssInit関数で設定)*/
  char *tmpPath;   /*一時ファイル用ディレクトリパス名*/
  char *xmlDefVer; /*XMLのデフォルトバージョン*/
  char *xmlDefEnc; /*XMLのデフォルトエンコーディング*/
  char *xtDefVer;  /*XMLtableのデフォルトバージョン*/
  int    txtFlg;   /*XMLtableでなく、plain textデータを使うフラグ(mssSetOption関数で設定*/
  int    allocDeb; /*領域確保変数のデバッグフラグ*/
  struct mssAllocInf allocInf[50000];
  int    allocCnt;   /*{M,C,Re}allocで領域確保した回数*/
  int    allocFreeCnt; /*{M,C,Re}alloc-Freeで領域確保されている数(全て開放していれば最後には0になるはず)*/
  int    writeHeaderFlg; /*ヘッダーを既に出力していたら１、さもなければ０(mssWriteHeader関数でセット)*/
  int    writeFooterFlg; /*フッターを既に出力していたら１、さもなければ０*/
  int    usedTempFileFlg;   /*一時ファイルを利用しているフラグ*/
  /* char   sigDigitsForm[30];*/
  char  *sigDigitsForm; /*最大有効桁数(%.10gなど)*/
};

/**
 * # STRUCT #
 * 文字列をConcatenateし、一つの文字列領域を作成する構造体
 */
struct mssStrings {
  char *str;    /*先頭文字*/
  int   cnt;    /*文字数*/
};

/**
 * # STRUCT #
 * 文字列を配列リストとして登録する構造体
 * 登録されたn番目の文字列へのポインタによるアクセスが可能
 */
struct mssStrList {
  char *str;     /*文字列リストの先頭*/
  int  *pointer; /*各文字列の相対的位置(先頭からの文字数)が入る*/
  int   cnt;     /*登録された文字列数*/
  int   chrCnt;  /*登録された総文字数*/
};

/**
 * # PROTOTYPE # 
 */
void 			mssSetSignalHandler();
void			mssInit(int argc, char **argv, struct mssComHelp *comHelp);
void			mssEnd(int status);
void 			mssShowStartMsg();
void 			mssShowEndMsg();
void 			mssShowErrMsg(char *msg, ...);
void 			mssShowMsg(char *msg, ...);
void *			mssCalloc(int size, char *errMsg);
void *			mssMalloc(int size, char *errMsg);
void *			mssRealloc(void *ptr, int size, char *errMsg);
void *			mssReallocLim(void *ptr,int size,int lim,char *errMsg);
char *			mssStrdup(char *s);
void			mssFree(void *add);
void			mssShowAllocInf(void);
void			mssAddAllocLabel(char *msg);
struct mssStrings *	mssInitStrings();
void 			mssFreeStrings(struct mssStrings *s);
void 			mssCatStrings(struct mssStrings *s, char *str);
void			mssCatnStrings(struct mssStrings *s, char *str, int n);
struct mssStrList *	mssInitStrList();
void 			mssFreeStrList(struct mssStrList *s);
void 			mssPutStrList(struct mssStrList *s, char *str);
char *			mssGetStrList(struct mssStrList *s,int n);
char *                  mssCatTwoStrings(char *str1, char *str2);
char *			mssSkipStrBlock(char *str, char startChr, char endChr);
void			mssSwapInt(int *x, int *y);
void			mssSwapLng(long *x, long *y);
void			mssSwapDbl(double *x, double *y);
char **			mssTokByChr(char *string, char tok, int *cnt, int dup);
int			mssIsValidStr(char *str);
char *			mssItoA(int num);
char *			mssFtoA(double num);
time_t			mssStrToTime(char *str);
int			mssInitRand(int seed);
double			mssRand();
int			mssIRand(int from, int to);
double			mssNRand(double m, double s);
int			mssPRand(double m);
void			mssSort(char **data, int cnt, int flag);


#endif /* _FP_H */
