/**
 * # CHAPTER #
 * ============================================================================
 * xtcal等で利用される計算式に関するヘッダーファイル
 * 20040121 sys/types.h追加(増田氏のご指摘for FreeBSD49)
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssValue.h>
#include <musashi/mssHeader.h>
#include <sys/types.h>
#include <regex.h>

#ifndef __MSSCAL_H
#define __MSSCAL_H

/**
 * # DEFINE #
 *一つの関数がとる、引数の最大数
 */
#define MaxCalArg 128  /*一つの関数がとる、引数の最大数*/

/**
 * # STRUCT #
 * 関数や演算子の引数
 */
struct Arg {
  MssValue      val[MssFieldMaxCnt];/*引数の値(複数あるのは項目ワイルドカード用)*/
  int        valCnt;             /*値の個数*/
  char         *str;             /**/
  int           datType;         /*引数の型(N,S,X)*/
  int           type;            /*引数のタイプ(NODE,LEAF(CONST, FIELD)*/
  struct mssCal   *node;         /*引数が関数や演算子なら、そのノード*/
  struct mssFields *flds;        /*type==FIELDならば、その項目*/
  MssValue         constant;        /*type=CONSTならば、その値*/
};

/**
 * # STRUCT #
 *関数の各種情報
 */
struct Func {
  char name[32];                 /*関数名*/
  int  type;                     /*関数,演算子の種類 0:関数 n:n項演算子*/
  int  priority;                 /*演算子の優先順位*/
  int  argType[MaxCalArg];       /*引数の型(N,S,X)*/
  int  retType;                  /*返値の型(N,S,X)*/
  unsigned char procType;        /*利用可能処理タイプ*/
  MssValue (*pnt)(struct mssCal *cal); /* 関数のアドレス*/

  /*以下は上記変数から計算して求められる*/
  int  argCnt;                   /*引数の数(最低必要な数)*/
  int  argMul;                   /*可変引数を含むかどうか*/
  int  mulBcnt;                  /*可変引数の場所の前に何個引数があるか*/
  int  mulAcnt;                  /*可変引数の場所の後に何個引数があるか*/
                                 /*{S,S,M,N,N,N}: mulBcnt=1, mulAcnt=3*/
};                               /*   ~~~                             */

/**
 * # STRUCT #
 * 計算式構造体
 */
struct mssCal {
  struct Func *func;          /* 関数情報*/
  int         argCnt;         /* 引数の数*/
  struct Arg  arg[MaxCalArg]; /* 引数*/
  int         retType;        /* このノードの返値タイプ*/
  struct mssCal *parent;      /* 親ノード*/
  regex_t *regex;             /* 正規表現を使う関数の場合、そのコンパイル結果*/
};

/**
 * # PROTOTYPE # 
 */
void		mssCalReadFuncIsFldRec(struct mssCal *cal,struct mssFldRec *fr);
void		mssCalReadFuncIsFRK(struct mssCal *cal,struct mssFldRecKey *frk);
void		mssCalReadFuncIsFRD(struct mssCal *cal,struct mssFldRecDbl *frd);
struct mssCal *	mssCalCompile(char *str, struct mssHeader *hd);
void		mssCalShowTree(struct mssCal *cal,int level);
MssValue	mssCalculate(struct mssCal *cal, char **pnt);
void		mssCalFree(struct mssCal *cal);

#endif /*_CAL_H*/
