
#ifndef __MSSCONFIG_H
#define __MSSCONFIG_H 1

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

/**
 * # DEFINE #
 * 有効桁数
 */
#define MssSigDigits 10


/**
 * # DEFINE #
 * ファイル名(パス込)の最大長
 */
#define MssFileNameMaxLen 256

/**
 * # DEFINE #
 * 一行あたりの最大文字数(バッファ重複させるサイズ)
 */
#define MssRecordMaxLen 10240 

/**
 * # DEFINE #
 * 一項目たりの最大文字数
 */
#define MssFieldMaxLen 2048

/**
 * # DEFINE #
 * 一行あたりの最大項目数
 */
#define MssFieldMaxCnt 2048 

/**
 * # DEFINE #
 * 項目名の最大長
 */
#define MssFieldNameMaxLen 256

/**
 * # DEFINE #
 * XMLtableのheader内タイトルの最大長
 */
#define MssTitleMaxLen 256

/**
 * # DEFINE #
 * XMLtableのheader内コメントの最大長
 */
#define MssCommentMaxLen 10240

/**
 * # DEFINE #
 * ライブラリ関数が用いるデフォルトの一時ファイル用ディレクトリ
 */
#define MssTempDir "/tmp"

/**
 * # DEFINE #
 * XMLtableのデフォルトバージョン
 */
#define MssXtDefVer 11

/**
 * # DEFINE #
 * XMLのデフォルトバージョン
 */
#define MssXmlDefVer "1.0"

/**
 * # DEFINE #
 * XMLtableのXMLタグ名の最大長
 */
#define MssXtTagNameMaxLen 256

/**
 * # DEFINE #
 * XMLtableのXML属性の最大数
 */
#define MssXtAttributeMaxCnt 10

/**
 * # DEFINE #
 * XMLtableのデータ項目のDelimiter(文字)
 */
#define MssFieldDelim ' '

/**
 * # DEFINE #
 * XMLtableのデータ項目のDelimiter(文字列)
 */
#define MssFieldDelimStr " "

/**
 * # DEFINE #
 * XMLtableのデータのNULL文字を表す文字
 */
#define MssNullChr '*'

/**
 * # DEFINE #
 * XMLtableのデータのNULL文字を表す文字(文字列として)
 */
#define MssNullStr "*"


/**
 * # MACRO #
 * char *sがNULL値かどうかの判定マクロ
 */
#define MssIsNull(s)  ((*(s))==MssNullChr)

/**
 * # DEFINE #
 * データの開始識別文字列
 */
#define MssBeginBodyString "<body><![CDATA["

/**
 * # DEFINE #
 * データの終了識別文字列
 */
#define MssEndBodyString "]]></body>"

/**
 * # DEFINE #
 * 0とみなすdouble型数値の範囲(、0±DBL0は0とみなす)
 */
#define DBL0 0.00000001

#endif /* _XTCONFIG_H */

