/**
 * # CHAPTER #
 * ============================================================================
 * XMLtableのヘッダー関連のヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssOutput.h>
#include <musashi/mssOption.h>

#ifndef __MSSHEADER_H
#define __MSSHEADER_H 1

#include <musashi/mssInput.h>

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目の項目番号を得る。
 */
#define MssFlds2num(flds,i) ((*((flds)->fi+(i)))->num)

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目の項目名を得る。
 */
#define MssFlds2name(flds,i) ((*((flds)->fi+(i)))->name)

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目のソート優先順位番号を得る。
 */
#define MssFlds2priority(flds,i) ((*((flds)->fi+(i)))->priority)

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目の逆順ソートフラグを得る。
 */
#define MssFlds2revFlg(flds,i) ((*((flds)->fi+(i)))->revFlg)

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目の数値ソートフラグを得る。
 */
#define MssFlds2numFlg(flds,i) ((*((flds)->fi+(i)))->numFlg)

/**
 * # MACRO #
 * mssFields構造体に格納されたi番目の項目の長さ(固定長時のみ)を得る。
 */
#define MssFlds2length(flds,i) ((*((flds)->fi+(i)))->length)

/**
 * # STRUCT #
 * xmlTablの項目に関する情報を格納する構造体
 */
struct mssFldInfo {
  int    num;     /*項目番号(0から始まる)*/
  char  *name;    /*項目名*/
  int    priority;/*ソートのキー優先番号(1から始まる、無しは0)*/
  int    revFlg;  /*逆順ソートフラグ(0 or 1)*/
  int    numFlg;  /*数値ソートフラグ(0 or 1)*/
  int    length;  /*固定長のときの項目長(情報なしの場合は0)*/
  char  *comment; /*項目のコメント(情報なしの場合はNULL)*/
};

/**
 * # STRUCT #
 * 複数項目を格納する構造体
 */
struct mssFields {
  struct mssFldInfo **fi; /*mssFldInfoへのポインタ配列*/
  int cnt;                /*項目の数*/
};

/**
 * # STRUCT #
 * xmlTableのヘッダー情報を格納する構造体
 */
struct mssHeader {
  struct mssFields * flds;  /*項目情報*/
  char *             title;   /*タイトル文字列*/
  char *             comment; /*コメント文字列(改行は保存される)*/
  int                version; /*xmlTableのバージョン(1.0->10, 1.1->11)*/
  char *             xmlver;  /*XMLバージョン*/
  char *             xmlenc;  /*XMLエンコーディング*/
  int                datTop;  /*実際のデータが始まるまでの文字数*/
  int                recCnt;  /*レコード行数(情報なしの場合は-1)*/
};

/**
 * # PROTOTYPE # 
 */
struct 			mssFldInfo *mssInitFldInfo();
void 			mssFreeFldInfo( struct mssFldInfo *fi);
void 			mssShowFldInfo(struct mssFldInfo *fi);
struct mssFldInfo *     mssFldNum2Add(struct mssFields *flds, int num);
struct mssFldInfo *	mssFldNam2Add(struct mssFields *flds, char *name);
struct mssFldInfo **	mssFldGlbNam2Add(struct mssFields *flds, char *name);
int 			mssFldNam2Num(struct mssFields *flds, char *name);
int 			mssFldNum2SrtPri(struct mssFields *flds, int num);
int 			mssFldNum2SrtRev(struct mssFields *flds, int num);
int 			mssFldNum2SrtNum(struct mssFields *flds, int num);
void 			mssFreeHeader(struct mssHeader *hd);
struct mssHeader *	mssInitHeader(char *title, char *comment);
struct mssHeader *	mssInitCpyHeader(struct mssHeader *old);
struct mssHeader *	mssInitSetHeader( char *title, char *comment, char *xmlver, char *xmlenc, int version);
void 			mssSetHeaderRecCnt(struct mssHeader *hd, int recCnt);
struct mssFields *	mssInitFields();
void 			mssFreeFields(struct mssFields *flds);
void 			mssShowFields(struct mssFields *flds);
void			mssUpdateFieldsSortPriority(struct mssFields *flds);
void			mssSetFldInfoSort(struct mssFldInfo *fi, int prioriy, int revFlg,int numFlg);
void			mssClearFieldsSort(struct mssFields *flds);
void			mssSetFieldsSort(struct mssFields *flds, struct mssFields *sortFlds);
void			mssSetFieldsSortPriority(struct mssFields *flds);
void			mssSetFldInfoLength(struct mssFldInfo *fi, int length);
void			mssSetFldInfoNum(struct mssFldInfo *fi, int num);
void			mssSetFldInfoName(struct mssFldInfo *fi, char *name);
void			mssSetFldInfoComment(struct mssFldInfo *fi, char *comment);
void 			mssSetFieldsSequenceNum(struct mssFields *flds);
void		 	mssAddFieldsByStr(struct mssFields *flds, char *str);
void			mssAddFieldsByStrList(struct mssFields *flds, char **str, int cnt);
void			mssAddFieldsByFldInfo(struct mssFields *flds, struct mssFldInfo *fi);
void			mssAddFieldsByFldInfoList(struct mssFields *flds, struct mssFldInfo **fi);
void			mssAddFieldsByFields(struct mssFields *flds, struct mssFields *addFlds);
void			mssAddHeadOrOptFields(struct mssFields *flds, struct mssHeader *hd, MssOptFLD *optFld);
void			mssWriteFldInfo(struct mssFldInfo *fi, int version, struct mssFPW *fp);
void			mssWriteHeader( struct mssHeader *hd, struct mssFPW *fp);
void			mssWriteFooter(struct mssFPW *fp);
void			mssCreateBlankXtFile(char **fldName, int fldCnt, char *fname);
struct mssHeader *	mssReadHeader( struct mssFPR *fp);
void			mssShowHeader(struct mssHeader *hd);
int			mssChkSorted( struct mssFields *sf, struct mssHeader *hd);
void			mssSetOptFld(MssOptFLD *optFLD, struct mssHeader *hd);
void			mssSetOptKey(MssOptKEY *optKEY, struct mssHeader *hd);

#endif /* _HEADER_H */

