/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIで用いられるその他ヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssValue.h>
#include <musashi/mssHeader.h>

#ifndef __MSSMISC_H
#define __MSSMISC_H 1

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 赤黒木(Red Black Tree)
 * ----------------------------------------------------------------------------
 */

/**
 * # STRUCT #
 * 赤黒木のノードで利用するキー構造体
 */
struct mssRBkey {
  MssValue v; /*このキーの大小によってプライオリティが決まる*/
  void *add;  /*汎用アドレス*/
};
  
/**
 * # STRUCT #
 * 赤黒木のノード構造体
 */
struct mssRBnode {
  struct mssRBkey  *key;
  struct mssRBnode *parent, *left, *right;
  int    rank;
};

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 範囲インデックス
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * 範囲集合を値と条件を持つノードに格納(リスト構造)
 */
struct RangeNode {
  MssValue v;   /* ノードの値 */
  char **recLT; /* vより小さい条件をもつレコード集合(range->rec)*/
  char **recLE; /* v以下条件をもつレコード集合(range->rec)*/
  char **recIN; /* このノードの値のを含むレコード集合(range->rec)*/
  char **recGE; /* v以上条件をもつレコード集合(range->rec)*/
  char **recGT; /* vより大きい条件をもつレコード集合(range->rec)*/
  int  cntLT;   /* 以下、上記変数に登録された件数(range->rec)*/
  int  cntLE;
  int  cntIN;
  int  cntGE;
  int  cntGT;
  struct RangeNode *next;
  int procLTGE; /*joinフェーズで利用。このnodeのLT,GEをstackに反映フラグ*/
  int procLEGT; /*joinフェーズで利用。このnodeのLE,GTをstackに反映フラグ*/
};

/**
 * # FUNCTION #
 * マスター上の範囲、JOINする値を格納
 */
struct Range {
  MssValue st;
  int      stEq;
  MssValue ed;
  int      edEq;
  char *rec;
};

/**
 * # FUNCTION #
 * マスター上の全行(-kの項目の値が同じ行)のRangeを格納
 */
struct RangeTbl {
  struct Range **range;
  int cnt;
};

/**
 * # FUNCTION #
 * 範囲インデックス
 */
struct RangeIndex {
  struct RangeTbl *tbl;
  struct RangeNode *list;
  int nsFlg; /*数値範囲(1)か文字列範囲(0)か*/
};

/**
 * # PROTOTYPE # 
 */

struct mssRBnode *	mssRBinit(int keyType);
void 			mssRBfree(struct mssRBnode *v);
void 			mssRBshowTree(char *s,struct mssRBnode *pp);
int 			mssRBdelete(struct mssRBnode *v, MssValue value);
int 			mssRBinsert(struct mssRBnode *v,MssValue value,void *add);
struct mssRBnode *	mssRBinsertAdd( struct mssRBnode *v, MssValue value, void *add);
struct mssRBnode *      mssRBfindMax(struct mssRBnode *v);
struct mssRBnode *      mssRBfindMin(struct mssRBnode *v);

struct mssRBnode *	mssRBmember(struct mssRBnode *n, MssValue value);
int			mssRBisExternalNode(struct mssRBnode *v);

struct RangeIndex *	mssSetRangeIndexFrk(struct mssFldRecKey *frkM, struct mssFields *flds, int stFldNo, int edFldNo, int nsFlg, int stEQflg, int edEQflg);

void 			mssShowRangeIndex(struct RangeIndex *rIndex);
void 			mssFreeRangeIndex(struct RangeIndex *rIndex);
void			mssProcLTGE(struct mssRBnode *rb, struct RangeNode *node);
void			mssProcLEGT(struct mssRBnode *rb, struct RangeNode *node);


#endif
