
/* 2004/10/18 OptSELの定義を削除 */

#ifndef __MSSOPTION_H
#define __MSSOPTION_H 1

#include <musashi/mssBase.h>

/**
 * # ENUM #
 * コマンドオプションの型
 */
enum OptType {
  OSTR, /*文字列型      */
  OSEL, /*文字列選択型  */
  OSLS, /*文字列リスト型*/
  OSRL, /*複数文字列範囲列挙型*/
  OINT, /*int型         */
  OILS, /*intリスト型   */
  ORNG, /*int範囲型     */
  ORAG, /*汎用範囲型    */
  ODBL, /*double型      */
  ODLS, /*doubleリスト型*/
  OINF, /*入力ファイル型*/
  OOTF, /*出力ファイル型*/
  OFLD, /*項目型        */
  OKEY, /*key項目型     */
  OFLG  /*フラグ型      */
};

/**
 * # STRUCT #
 * 文字列型
 */
struct OptSTR {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト*/
  int           minLen;  /*要素の最小文字数*/
  int           maxLen;  /*要素の最大文字数*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSTR MssOptSTR;

/**
 * # STRUCT #
 * 文字列選択型
 */
struct OptSEL {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト*/
  char         *selList; /*文字列選択リスト*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  char         *selListTitle; /*文字列選択リストタイトル*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSEL MssOptSEL;

/**
 * # STRUCT #
 * 複数文字列型 ex) "a:b,x,p:q"
 */
struct OptSLS {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト*/
  int           maxCnt;  /*リスト要素の最大数*/
  int           minLen;  /*要素の最小文字数*/
  int           maxLen;  /*要素の最大文字数*/
  int           colFlg;  /*要素内コロン指定可能フラグ ex) abc:xyz*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  char        **strList; /*実際の値*/
  char        **colList; /*要素内コロン以下の文字列*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSLS MssOptSLS;

/**
 * # STRUCT #
 * 複数文字列範囲列挙型
 * ex)
 * str    = "abc~def:e:g~p,  p:q:ddd~zzz, a"
 * from   ={ {"abc","e" ,"g"}, {"p" ,"q" ,"ddd"}, { "a"} }
 * to     ={ {"def",NULL,"p"}, {NULL,NULL,"zzz"}, {NULL} }
 * valCnt ={ 3,            , 3,                 1      }
 * cnt    =3
 */
struct OptSRL {
  enum OptType  type;     /*オプションタイプ*/
  char         *keyWord;  /*キーワード文字*/
  int           must;     /*指定必須フラグ*/
  char         *def;      /*デフォルト*/
  int           maxCnt;   /*要素(コロン区切)の最大数*/
  int           maxValCnt;/*要素内での値(カンマ区切)の最大数*/
  int           minValLen;/*値の最小文字数*/
  int           maxValLen;/*値の最大文字数*/
  int           rngFlg;   /*範囲指定可能フラグ*/
  char         *title;    /*パラメータタイトル*/
  char         *comment;  /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  char       ***from;    /*範囲from*/
  char       ***to;      /*範囲to*/
  int          *valCnt;  /*各要素での値の個数*/
  int           cnt;     /*要素の個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSRL MssOptSRL;

/**
 * # STRUCT #
 * 整数型
 */
struct OptINT {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  int           def;     /*デフォルト*/
  int           min;     /*要素の最小値*/
  int           max;     /*要素の最大値*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  int           val;     /*実際の値*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptINT MssOptINT;

/**
 * # STRUCT #
 * 整数リスト型
 */
struct OptILS {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト(文字列で)*/
  int           maxCnt;  /*リスト要素の最大数*/
  int           min;     /*要素の最小値*/
  int           max;     /*要素の最大値*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  int          *val;     /*実際の値*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptILS MssOptILS;

/**
 * # STRUCT #
 * 整数範囲型
 */
struct OptRNG {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト(文字で)*/
  int           maxCnt;  /*リスト要素の最大数*/
  int           min;     /*要素の最小値*/
  int           max;     /*要素の最大値*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  int          *from;    /*実際の値リスト(from)*/
  int          *to;      /*実際の値リスト(to)*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptRNG MssOptRNG;

/**
 * # STRUCT #
 * 汎用範囲型
 */
struct OptRAG {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト(文字で)*/
  int           maxCnt;  /*リスト要素の最大数*/
  int           colFlg;  /*要素内コロン指定可能フラグ*/
  int           optFlg;  /*要素内オプション指定可能フラグ*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/

  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  char        **st;      /*実際の値リスト(開始)*/
  char        **ed;      /*実際の値リスト(終了)*/
  int          *stEq;    /*開始条件にEqualを含むフラグ(1:含む,0:含まない)*/
  int          *edEq;    /*終了条件にEqualを含むフラグ(1:含む,0:含まない)*/
  char        **val;     /*オプションリスト*/
  char        **opt;     /*オプションリスト*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptRAG MssOptRAG;

/**
 * # STRUCT #
 * 実数型
 */
struct OptDBL {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  double        def;     /*デフォルト*/
  double        min;     /*要素の最小値*/
  double        max;     /*要素の最大値*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  double        val;     /*実際の値*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptDBL MssOptDBL;

/**
 * # STRUCT #
 * 実数リスト型
 */
struct OptDLS {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *def;     /*デフォルト(文字列で)*/
  int           maxCnt;  /*リスト要素の最大数*/
  double        min;     /*要素の最小値*/
  double        max;     /*要素の最大値*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  double       *val;     /*実際の値*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptDLS MssOptDLS;

/**
 * # STRUCT #
 * 入力ファイル型
 */
struct OptINF {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  int           maxCnt;  /*リスト要素の最大数*/
  int           fnf;     /*1:file not foundのエラーで終了しない 0:する*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  char        **strList; /*実際の値*/
  int           cnt;     /*リストの個数*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptINF MssOptINF;

/**
 * # STRUCT #
 * 出力ファイル型
 */
struct OptOTF {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           must;    /*指定必須フラグ*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptOTF MssOptOTF;

/**
 * # STRUCT #
 * フラグ型
 */
struct OptFLG {
  enum OptType  type;    /*オプションタイプ*/
  char         *keyWord; /*キーワード文字*/
  int           def;     /*基本的にはset(1). 常にonにしたいときの為*/
  char         *title;   /*パラメータタイトル*/
  char         *comment; /*パラメータコメント*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptFLG MssOptFLG;

/**
 * # STRUCT #
 * 項目型
 */
struct OptFLD {
  enum OptType  type;        /*オプションタイプ*/
  char         *keyWord;     /*キーワード文字*/
  int           must;        /*指定必須フラグ*/
  int           maxCnt;      /*リスト要素の最大数(正規表現展開後)*/
  char         *inKeyWord;   /*対象とする入力データのキーワード(GUIで利用)*/
  int           globFlg;     /*ワイルドカード許可フラグ*/
  int           newFlg;      /*新項目名の指定可能フラグ*/
  char         *fldOptSel;   /*項目オプション選択肢*/
  char         *title;       /*パラメータタイトル*/
  char         *comment;     /*パラメータコメント*/
  char         *fldOptTitle; /*項目オプション選択肢*/
  
  int           set;     /*コマンドライン上で指定されたよフラグ*/
  char         *str;     /*オプション文字列:argvをstrdupしたもの*/
  char        **nam;     /*項目名リスト*/
  char        **newNam;  /*新項目名リスト(指定がなければnamと同じ)*/
  char        **fldOpt;  /*項目オプションリスト(指定がなければNULL)*/
  int           cnt;     /*リストの個数*/

  struct mssFields *flds;
  int *fldNo2optNo;

};

/**
 * # TYPEDEF #
 */
typedef struct OptFLD MssOptFLD;

/**
 * # STRUCT #
 * キー項目型
 */
struct OptKEY {
  enum OptType  type;      /*オプションタイプ*/
  char         *keyWord;   /*キーワード文字*/
  int           must;      /*指定必須フラグ*/
  int           maxCnt;    /*リスト要素の最大数(正規表現展開後)*/
  char         *inKeyWord; /*対象とする入力データのキーワード(GUIで利用)*/
  int           def;       /*1:diff,2:same */
  char         *title;     /*パラメータタイトル*/
  char         *comment;   /*パラメータコメント*/
  
  int           set;       /*コマンドライン上で指定されたよフラグ*/
  char         *str;       /*オプション文字列:argvをstrdupしたもの*/
  char        **nam;       /*項目名リスト*/
  int           diffSame;  /*0:-kの指定有り,1:diff,2:same*/
  int           cnt;       /*リストの個数*/

  struct mssFields *flds;
  int *fldNo2optNo;
};

/**
 * # TYPEDEF #
 */
typedef struct OptKEY MssOptKEY;


/**
 * # PROTOTYPE # 
 */
void	mssHelpDoc(void *opt[],struct mssComHelp *comHelp, int argc, char **argv);
void	mssFreeOption(void *opt[]);
void	mssSetOption(void *opt[], int argc, char *argv[]);
void	mssShowOption(void *opt[]);
int	mssIsFldOptOn(MssOptFLD *optFld,int i, char c );
void	mssCpyOptKey(MssOptKEY *to,MssOptKEY *from);
void	mssCpyOptFld(MssOptFLD *to,MssOptFLD *from);
int	mssIsInRange(MssOptRNG *optRNG,int val);

#endif /* _OPTION_H */

