
/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIで用いられる出力関連のヘッダーファイル
 * ============================================================================
 */

#include <stdio.h>
#include <zlib.h>

#ifndef _MSSOUTPUT_H
#define _MSSOUTPUT_H

/**
 * # STRUCT #
 * 出力ファイル構造体
 */
struct mssFPW {
  char *fName;  /*ファイル名へのポインタ(NULL:標準出力 1:標準エラー出力)*/
  FILE  *fp;    /*ファイルハンドラ*/
  int    zflg;  /*圧縮ファイルを使うフラグ*/
  gzFile zfd;   /*圧縮ファイルへ*/
};

/**
 * # PROTOTYPE # 
 */
struct mssFPW *	mssOpenFPW(char *fileName, int z, int d);
void		mssCloseFPW(struct mssFPW *fp);
void		mssWriteDlm(struct mssFPW *fp);
void		mssWriteRet(struct mssFPW *fp);
void		mssWriteStr(char *str,struct mssFPW *fp);
void		mssWriteChr(char chr,struct mssFPW *fp);
void		mssWriteInt(int num,struct mssFPW *fp);
void		mssWriteNull(struct mssFPW *fp);
void		mssWriteTime(struct mssFPW *fp, int sepFlg);
void		mssWriteDate(struct mssFPW *fp, int sepFlg);
void		mssWriteDbl(double num,struct mssFPW *fp);
void		mssWriteDbe(double num,struct mssFPW *fp);
void		mssWriteFld(char **str, int cnt, char *endStr, struct mssFPW *fp);

#endif
