/**
 * # CHAPTER #
 * ============================================================================
 * ユニーク(unique)処理関連のヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssOption.h>
#include <musashi/mssOutput.h>

#ifndef _MSSUNIQ_H
#define _MSSUNIQ_H

/**
 * # DEFINE #
 * マージソートユニークを行う際に、何個までのファイルを同時に併合させるか
 */
#define PWayU 25

/**
 * # DEFINE #
 * 赤黒木で使用するメモリ量上限値
 */
#define MaxMemU 2048000

/**
 * # STRUCT #
 * 赤黒木で集計するための構造体
 */
struct mssUnqDat {
  int              fldCnt;        /*データ一行の項目数*/
  MssOptKEY *      optKey;        /*キー項目オプション*/
  int              procType;      /*0:シーケンシャル集計,1:RBtree*/
  struct RBUQnode *rb;            /*赤黒木プライオリティキュー*/
  struct mssFPR   *iFile[PWayU];  /*入力ワークファイルポインタ(text部)*/
  char             prefixTxt[MssFileNameMaxLen]; /*一時Fileのプレフィックス(text部)*/
  struct mssFldRec *fr[PWayU];      /*入力ワークファイル読み込みバッファ*/
  char            *tmpDir;         /*ワークファイルのパス*/
  int              iStart;         /*開始入力ファイル番号*/
  int              iEnd;           /*終了入力ファイル番号*/
  int             *inCnt;          /*入力データのカウンタへのポインタ*/
};

/**
 * # STRUCT #
 * 赤黒木のノードで利用するキー構造体
 */
struct RBUQkey {
  char    *str;    /*項目が\0で区切られた一レコード*/
  char   **fld;    /*strの各項目へのポインタ*/
  int     *bkt;    /*集計されたバケットの番号*/
  int      bktCnt; /*その時までに集計されたバケットの数*/
};
  
/**
 * # STRUCT #
 * 赤黒木のノード構造体
 */
struct RBUQnode {
  struct RBUQkey  *key; /*このキーの大小によってプライオリティが決まる*/
  struct RBUQnode *parent, *left, *right;
  int    rank;
};

/**
 * # PROTOTYPE #
 */
struct mssUnqDat *	mssInitUnqDat(int fldCnt, MssOptKEY *optKey, char *tmpDir, int *inCnt);
int			mssReadWriteUnq(struct mssUnqDat *ud, struct mssFPW *fpw);
void			mssFreeUnqDat(struct mssUnqDat *ud);
void			mssPreUnq( struct mssUnqDat *ud, struct mssFPR *iFile);

#endif /*_MSSUNIQ_H*/
