/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIで用いられる値関連のヘッダーファイル
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssOutput.h>

#include <time.h>

#ifndef __MSSVALUE_H
#define __MSSVALUE_H 1

/**
 * # MACRO #
 * 値をNULLに設定するマクロ
 */
#define MssVnull(v) ((v).nul=1)

/**
 * # ENUM #
 * オペレータ列挙体
 */
enum OpeType {
  OPE_EQ, /* ==   */
  OPE_NE, /* !=   */
  OPE_LT, /* <    */
  OPE_LE, /* <=   */
  OPE_GT, /* >    */ 
  OPE_GE  /* >=   */
};

/**
 * # UNION #
 * 実際に値を保存する共用体
 */
union V {
  int     i;
  double  d;
  char   *s;
  void   *a;
  unsigned short int usi;
};

/**
 * # ENUM #
 * 値の種類の列挙体
 */
enum vType {
  INT, /* int     */
  DBL, /* double  */
  STR, /* char *  */
  ADD, /* void *  */
  USI, /* unsignd short int */
};

/**
 * # STRUCT #
 * 全ての値を収める構造体
 */
struct MssValueStruct {
  enum  vType vType;
  union V     v;
  int   nul; /*null値の場合:1*/
};

/**
 * # TYPEDEF #
 */
typedef struct MssValueStruct MssValue;

/**
 * # PROTOTYPE # 
 */
void 		mssVinit(MssValue *v, enum vType vType);
void 		mssVclear(MssValue *v);
void 		mssVclearMin(MssValue *v);
void 		mssVclearMax(MssValue *v);
MssValue 	mssVint2i(int i);
MssValue 	mssVint2d(int i);
MssValue 	mssVint2s(int i);
MssValue 	mssVdbl2i(double d);
MssValue 	mssVdbl2d(double d);
MssValue 	mssVdbl2s(double d);
MssValue 	mssVstr2i(char *str);
MssValue 	mssVstr2d(char *str);
MssValue 	mssVstr2s(char *str);
MssValue 	mssVi2d(MssValue v);
MssValue 	mssVi2s(MssValue v);
MssValue 	mssVd2i(MssValue v);
MssValue 	mssVd2s(MssValue v);
MssValue 	mssVs2i(MssValue v);
MssValue 	mssVs2d(MssValue v);
MssValue	mssVadd(MssValue v1, MssValue v2);
MssValue 	mssVsub(MssValue v1, MssValue v2);
MssValue 	mssVmul(MssValue v1, MssValue v2);
MssValue 	mssVdiv(MssValue v1, MssValue v2);
MssValue 	mssVmod(MssValue v1, MssValue v2);
MssValue 	mssVsqrt(MssValue v);
MssValue 	mssVcntUp(MssValue v);
MssValue 	mssVcntDown(MssValue v);
MssValue 	mssVmin(MssValue v1, MssValue v2);
MssValue 	mssVmax(MssValue v1, MssValue v2);
int 		mssVcmpOpe(MssValue a, enum OpeType ope, MssValue b);
int 		mssVcmp(MssValue a, MssValue b);
void 		mssVwrite(MssValue v, struct mssFPW *fp);
void 		mssVwriteInt(MssValue v, struct mssFPW *fp);
void 		mssVwriteDbl(MssValue v, struct mssFPW *fp);
void 		mssVwriteStr(MssValue v, struct mssFPW *fp);

#endif
