/**
 * # CHAPTER #
 * ============================================================================
 * XML関連のヘッダーファイル
 * 2004/01/29 libiconvが必要な環境ではiconv.hをインクルードするように変更。
 * ============================================================================
 */

#include <musashi/mssOutput.h>
#include <musashi/mssBase.h>
#include <libxml/parserInternals.h>

#ifndef __MSSXML_H
#define __MSSXML_H 1

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#ifdef MssNeedLibiconv
#  include <iconv.h>
#endif

/**
 * # STRUCT #
 * XMLタグの構造体
 */
struct mssXmlTag {
  char *element;     /*要素名*/
  char **attributes; /*属性名-属性値リスト*/
  int  attCnt;       /*属性の数(偶数のはず)*/
};

/**
 * # PROTOTYPE # 
 */
char *			mssEncoding(char *str, iconv_t *icid);
char *			mssNencoding(char *str, int len, iconv_t *icid);
struct mssXmlTag *	mssInitXmlTag(char *element, iconv_t *icid);
struct mssXmlTag *	mssInitXmlTagByOpt(char *str, iconv_t *icid);
void			mssFreeXmlTag(struct mssXmlTag *xmlTag);
void			mssAddXmlTagAttributeFmt(struct mssXmlTag *xmlTag, char *name, iconv_t *icid, char *fmt, ...);
void			mssAddXmlTagAttributeStr(struct mssXmlTag *xmlTag, char *name, char *value, iconv_t *icid);
void			mssAddXmlTagAttributeInt(struct mssXmlTag *xmlTag, char *name, int value, iconv_t *icid);
void			mssAddXmlTagAttributeDbl(struct mssXmlTag *xmlTag, char *name, double value, iconv_t *icid);
struct mssXmlTag *	mssOpt2XmlTag(char *str, iconv_t *icid);
char *			mssXmlTag2emptyTag(struct mssXmlTag *xmlTag, iconv_t *icid);
char *			mssXmlTag2startTag(struct mssXmlTag *xmlTag, iconv_t *icid);
char *			mssXmlTag2endTag(struct mssXmlTag *xmlTag, iconv_t *icid);
void 			mssWriteXmlDeclaration( char *ver, char *enc, struct mssFPW *fp );
void			mssWriteXmlStartTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlEndTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlEmptyTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw);
void			mssWriteXmlContent(char *str, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlIndent(int cnt, struct mssFPW *fpw);
void			mssWriteXmlTagStr(int indCnt, char *elemet, char *content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagInt(int indCnt, char *elemet, int content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagDbl(int indCnt, char *elemet, double content, int retFlg, iconv_t *icid, struct mssFPW *fp );
void			mssWriteXmlTagFlg(int indCnt, char *elemet, int flg, int retFlg, iconv_t *icid, struct mssFPW *fp );

void			mssXmlDomErrHandler(void *ctxt, const char *msg, ...);

#endif /* _XML_H */

