/*		random.h		*/
#ifndef		_RANDOM_

#define		_RANDOM_

#include <math.h>
#include <string.h>

#define		MASK	123459876L	/* 初期化マスク（任意定数）*/
#define		NTAB	32			/* brnd(),ernd() 関連配列サイズ */
#define		MBIG	2147483647	/* krnd()関連定数 */
#define		MSEED	161803398	/*      〃        */
#define		ulong		unsigned long
#define		_M			17			/* 一様乱数の種類 */
#define		_MP			34			/* 一様乱数（拙速生成法）の種類 */

/*	random.c	*/
void _error(char *s, int r);
void init_urnd0(long seed);
void init_urnd1(long seed);
void init_urnd2(long seed);
void init_urnd3(long seed);
void init_urnd4(long seed);
void init_urnd5(long seed);
void init_urnd6(long seed);
void init_mrnd(long seed);
void init_rrnd(long seed);
void init_ornd0(long seed);
void init_ornd1(long seed);
void init_ornd2(long seed);
void init_brnd(long seed);
void init_ernd(long seed);
void init_krnd(long seed);
void init_drnd(long seed);
void init_qrnd(long seed);
long init_prnd0(long seed);
long init_prnd1(long seed);
long init_prnd2(long seed);
long init_prnd3(long seed);
long init_prnd4(long seed);
long init_prnd5(long seed);
long init_prnd6(long seed);
long init_prnd7(long seed);
long init_prnd8(long seed);
long init_prnd9(long seed);
long init_prnd10(long seed);
long init_prnd11(long seed);
long init_prnd12(long seed);
long init_prnd13(long seed);
long init_prnd14(long seed);
long init_prnd15(long seed);
long init_prnd16(long seed);
long init_prnd17(long seed);
long init_prnd18(long seed);
long init_prnd19(long seed);
long init_prnd20(long seed);
long init_prnd21(long seed);
long init_prnd22(long seed);
long init_prnd23(long seed);
long init_prnd24(long seed);
long init_prnd25(long seed);
long init_prnd26(long seed);
long init_prnd27(long seed);
long init_prnd28(long seed);
long init_prnd29(long seed);
long init_prnd30(long seed);
long init_prnd31(long seed);
long init_prnd32(long seed);
long init_prnd33(long seed);

double urnd0(void);
double urnd1(void);
double urnd2(void);
double urnd3(void);
double urnd4(void);
double urnd5(void);
double urnd6(void);
void rnd521(void);
double mrnd(void);
double rrnd(void);
double ornd0(void);
double ornd1(void);
double ornd2(void);
double brnd(void);
long bcal(void);
double ernd(void);
long ecal1(void);
long ecal2(void);
double krnd(void);
double drnd(void);
double qrnd(void);
double prnd0(void);
double prnd1(void);
double prnd2(void);
double prnd3(void);
double prnd4(void);
double prnd5(void);
double prnd6(void);
double prnd7(void);
double prnd8(void);
double prnd9(void);
double prnd10(void);
double prnd11(void);
double prnd12(void);
double prnd13(void);
double prnd14(void);
double prnd15(void);
double prnd16(void);
double prnd17(void);
double prnd18(void);
double prnd19(void);
double prnd20(void);
double prnd21(void);
double prnd22(void);
double prnd23(void);
double prnd24(void);
double prnd25(void);
double prnd26(void);
double prnd27(void);
double prnd28(void);
double prnd29(void);
double prnd30(void);
double prnd31(void);
double prnd32(void);
double prnd33(void);

void init_irnd(void (*initRND)(long s), double (*_rnd)(void), long seed);
int irnd(int max, int min);
void init_gaussd(void (*initRND)(long s), double (*_rnd)(void), long seed);
double gaussd(double av, double st);
void init_tri_rand(void (*initRND)(long s), double (*_rnd)(void), long seed);
double tri_rand(void);
void init_exp_rand(void (*initRND)(long s), double (*_rnd)(void), long seed);
double exp_rand(void);
void init_binormal(void (*initRND)(long s), double (*_rnd)(void), long seed);
void binormal(double r, double *x, double *y);
void init_rnd_vector(void (*initRND)(long s), double (*_rnd)(void), long seed);
void rnd_vector(double *x, double *y);
void init_rnd_vector3(void (*initRND)(long s), double (*_rnd)(void), long seed);
void rnd_vector3(double *x, double *y, double *z);

/*	global variables */
extern ulong _idum_u0, _idum_u1, _idum_u2;		/* urnd0()〜urnd6()の乱数核 */
extern ulong _idum_u3, _idum_u4, _idum_u5;		/*      〃        */
extern ulong _idum_u6;							/*      〃        */
extern ulong *_prx, *_prx_end;					/* mrnd()の乱数核ほか変数 */
extern ulong _rx[522];							/*      〃        */
extern unsigned int r_s1, r_s2, r_s3;			/* rrnd()の乱数核ほか変数 */
extern long _idum_o0, _idum_o1, _idum_o2;		/* ornd0()〜ornd2()の乱数核 */
extern long _idum_b, b_nd, b_iy;				/* brnd()の乱数核ほか変数 */
extern long b_iv[NTAB];							/*      〃        */
extern long _idum_e1, _idum_e2, e_nd, e_iy;		/* ernd()の乱数核ほか変数 */
extern long e_iv[NTAB];							/*      〃        */
extern long *k_ma_end, *pk1, *pk2;				/* krnd()の乱数核ほか変数 */
extern long k_ma[57];							/*      〃        */
extern ulong _idum_d;							/* drnd()の乱数核 */
extern ulong _idum_q;							/* qrnd()の乱数核 */
extern ulong _idum_p0, _idum_p1, _idum_p2;		/* prnd0()〜prnd33()の乱数核 */
extern ulong _idum_p3, _idum_p4, _idum_p5;		/*      〃        */
extern ulong _idum_p6, _idum_p7, _idum_p8;		/*      〃        */
extern ulong _idum_p9, _idum_p10, _idum_p11;	/*      〃        */
extern ulong _idum_p12, _idum_p13, _idum_p14;	/*      〃        */
extern ulong _idum_p15, _idum_p16, _idum_p17;	/*      〃        */
extern ulong _idum_p18, _idum_p19, _idum_p20;	/*      〃        */
extern ulong _idum_p21, _idum_p22, _idum_p23;	/*      〃        */
extern ulong _idum_p24, _idum_p25, _idum_p26;	/*      〃        */
extern ulong _idum_p27, _idum_p28, _idum_p29;	/*      〃        */
extern ulong _idum_p30, _idum_p31, _idum_p32;	/*      〃        */
extern ulong _idum_p33;							/*      〃        */

/*
random.cへ移動 by Hamuro

static char _pname[_M][7] = 
		{"urnd0", "urnd1", "urnd2", "urnd3", "urnd4", "urnd5",
		 "urnd6", "mrnd",  "rrnd",  "ornd0", "ornd1", "ornd2",
		 "brnd" , "ernd",  "krnd",  "drnd" , "qrnd" };
static double (*_func[_M])(void) =
		{urnd0, urnd1, urnd2, urnd3, urnd4, urnd5, urnd6, mrnd, rrnd,
		 ornd0, ornd1, ornd2, brnd,  ernd,  krnd,  drnd,  qrnd };
static void (*initRND[_M])(long s) =
		{init_urnd0, init_urnd1, init_urnd2, init_urnd3, init_urnd4, init_urnd5,
		 init_urnd6, init_mrnd,  init_rrnd,  init_ornd0, init_ornd1, init_ornd2,
		 init_brnd,  init_ernd,  init_krnd,  init_drnd,  init_qrnd };
static double (*_func_p[_MP])(void) = {
	prnd0,  prnd1,  prnd2,  prnd3,  prnd4,  prnd5,  prnd6,  prnd7,  prnd8,
	prnd9,  prnd10, prnd11, prnd12, prnd13, prnd14, prnd15, prnd16, prnd17,
	prnd18, prnd19, prnd20, prnd21, prnd22, prnd23, prnd24, prnd25, prnd26,
	prnd27, prnd28, prnd29, prnd30, prnd31, prnd32, prnd33 };
static long (*initRND_p[_MP])(long s) = {
	init_prnd0,  init_prnd1,  init_prnd2,  init_prnd3,  init_prnd4,
	init_prnd5,  init_prnd6,  init_prnd7,  init_prnd8,  init_prnd9,
	init_prnd10, init_prnd11, init_prnd12, init_prnd13, init_prnd14,
	init_prnd15, init_prnd16, init_prnd17, init_prnd18, init_prnd19,
	init_prnd20, init_prnd21, init_prnd22, init_prnd23, init_prnd24,
	init_prnd25, init_prnd26, init_prnd27, init_prnd28, init_prnd29,
	init_prnd30, init_prnd31, init_prnd32, init_prnd33 };
*/

extern double (*_rand)(void);				/* 一様乱数以外の乱数で呼び出す一様分布乱数 */ 
extern double _tri;

/* ランダム・データ生成関数 */
void init_mkdata(void (*initfunc)(long s), double (*func)(void), long seed);
int *mkdata_i(int n, int min, int max);
unsigned char *mkdata_c(int n, unsigned char min, unsigned char max);
double *mkdata_d(int n, double min, double max);
unsigned char **mkdata_s(int n, int smin, int smax, unsigned char min, unsigned char max);
unsigned char **mkdata_sd(int n, int smin, int smax, unsigned char min, unsigned char max);

/* データ撹拌関数 */
void shuffle_i(int *a, int n, long seed);
void shuffle_d(double *a, int n, long seed);
void shuffle_c(unsigned char **a, int n, long seed);

/* 無作為抽出関数 */
void init_pickup(void (*init)(long s), double (*rnd)(void), long seed);
void pickup(int m, int n, int *pick);

#endif
