/*
以下の文献に掲載されたソースを利用した。
河村知行「UNIXのクイックソートの罠」bit, vol 346, pp.21-27, 1995/7.
ソースファイルのOCR入力には、増田氏に協力頂いた。
*/

#include <stdlib.h>
#include <string.h>

extern unsigned int ass_cnt;                                   /* 評価用*/
typedef struct      { char *LL, *RR; } stack_node;             /* L,l R,rを積むスタックの構造体*/
#define PUSH(ll,rr) {top->LL = (ll); top->RR = (rr); ++top;}     /* L,l,R,rを積む*/
#define POP(ll,rr)  {--top; ll = top->LL; rr = top->RR;}     /* L,l,R,rを戻す*/
#define M(x,y)      {ass_cnt++; memcpy(x,y,size);}              /* yをxへ複写する*/
#define SWAP(x,y)   {M(s,x); M(x,y); M(y,s);}           /* */ 
#define IF3R        {if (l + size == m)             goto nxt;} /*  要素数３の時*/
#define IF3BR       {if (l + size == m) {M(m,s);    goto nxt;}}
#define IF3SR       {if (l + size == m) {SWAP(l,r); goto nxt;}}
#define SET_lr      {l += size; if ((r -= size) != m) M(m,r);} /* 右に空の要素を作る*/

void qsort5 (base, nel , size, cmp) char* base; int nel; int size; int (*cmp) ();
{
  register char *l, *r, *m;          /* l,r:左右の集団の端　m:配列の中央の位置*/
  register int t, eq_l, eq_r;        /* eq_l:左の集団が全てsに等しいことを示す*/
  char *s = (char*)malloc(size);     /* 分割要素を保存する所　SWAPにも使用*/
  char *L = base;                    /* 現在分割している区間の左端の要素の先頭*/
  char *R = &base[size * (nel - 1)]; /* 現在分割している区間の右端の要素の先頭*/
  int chklim = 100;                  /* 昇(降)順検査をする要素の下限*/
  stack_node stack[32], *top = stack;/* ３２ビットマシンでは３２で十分*/
  int n;

  if (nel <= 1) {free(s); return;}   /* 要素数が１以下の時は即終了する*/
  goto start;
  
  nxt:
  if (stack == top) {free(s); return;} /* スタックが空になったとき終了する*/
  POP(L,R);
  
  for (;;) {
    start:
    if (L+size == R) {if ((*cmp)(L,R) > 0) SWAP(L,R); goto nxt;} /* 要素数が２*/
    
    n=(R-L+size)/size;
    l = L; r = R;
//    m=l+size*(((r -1)/size+1)/2);       /* 配列の中央を決定*/
    m=L+size*(n >> 1);      /* 配列の中央を決定*/
    
    if ((t = (*cmp)(l,m)) < 0) {                                      /* 3-5-?*/
      if ((t = (*cmp)(m,r)) < 0) {                              /* 3-5-7の場合*/
        IF3R;
        if (chklim && nel >= chklim) {                   /* 既に昇順か検査する*/
          char *p;
          chklim = 0;
          for (p = l; p < r; p += size) if ((*cmp)(p,p+size) > 0) goto fail;
          goto nxt;
        }
        fail: M(s,m); goto loopA;
      }
      if (t > 0) {
        if ((*cmp)(l,r) <= 0) {M(s,r); M(r,m); IF3BR; goto loopA;} /* 3-5-4*/
        M(s,l); M(l,r); M(r,m); IF3BR; goto loopA;                 /* 3-5-2*/
      }
      IF3R; M(s,m); goto loopB;                                      /* 3-5-5*/
    }
    
    if (t > 0) {                                                      /* 7-5-?*/
      if ((t = (*cmp)(m,r)) > 0) {                              /* 7-5-3の場合*/
        IF3SR;
        if (chklim && nel >= chklim) {                   /* 既に降順か検査する*/
          char *p;
          chklim = 0;
          for  (p = l; p < r; p += size) if ((*cmp)(p,p+size) < 0) goto fail2;
          while (l<r){SWAP(l,r); l += size; r -= size;}/*区間全体を逆順にする*/
          goto nxt;
        }
        fail2: SWAP(l,r); M(s,m); goto loopA;                      /* 7-5-3*/
      }
      if (t < 0) {
        if ((*cmp)(l,r) <= 0) {M(s,l); M(l,m); IF3BR; goto loopB;} /* 7-5-8*/
        M(s,r); M(r,l); M(l,m); IF3BR; goto  loopA;                /* 7-5-6*/
      }
      IF3SR; M(s,r); M(r,l); M(l,m); goto loopA;                     /* 7-5-5*/
    }
    
    if ((t = (*cmp)(m,r)) < 0) {IF3R; M(s,m); goto loopA;}            /* 5-5-7*/
    if (t > 0) {IF3SR; M(s,l); M(l,r); M(r,m); goto loopB;}           /* 5-5-3*/
    
    IF3R; M(s,m); SET_lr; /* 5-5-5のときに分割の種類を決める*/        /* 5-5-5*/
    for (;;) {
      if ((t = (*cmp)(l,s)) > 0) {eq_l = 1; eq_r = 0; goto loopAx;}  /* 5-5-7*/
      if (t < 0)                 {eq_l = 0; eq_r = 1; goto loopBy;}  /* 5-5-3*/
      if ((l += size) >= r)      {M(l,s); goto nxt;}                 /* 5-5-5*/
    }
    
    loopA: SET_lr; eq_l = 1; eq_r = 0; /* タイプＡの分割     左 <= 分割値 < 右*/
    for (;;) {
      for (;;) {
        if ((t = (*cmp)(l,s)) > 0) break;
        if (t < 0) eq_l = 0;
        if ((l += size) >= r) goto fin;
      }
      loopAx:
      M(r,l); if (l >= (r -= size)) goto fin; /* 左から右へ放リ投げる*/
      for (;;) {
        if ((t = (*cmp)(r,s)) < 0) {eq_l = 0; break;}
        if (t == 0) break;
        if (l >= (r -= size)) goto fin;
      }
      M(l,r); if ((l += size) >= r) goto fin; /* 右から左へ放リ投げる*/
    }
    
    loopB: SET_lr; eq_l = 0; eq_r = 1; /* タイプＢの分割   　左 <= 分割値 < 右*/
    for (;;) {
      for (;;) {
        if ((t = (*cmp)(l,s)) > 0) {eq_r = 0; break;}
        if (t == 0) break;
        loopBy:
        if ((l += size) >= r) goto fin;
      }
      M(r,l); if (l >= (r -= size)) goto fin; /* 左から右へ放リ投げる*/
      
      for (;;) {
        if ((t = (*cmp)(r,s)) < 0) break;
        if (t > 0) eq_r = 0;
        if (l >= (r -= size)) goto fin;
      }
      M(l,r); if ((l += size) >= r) goto fin; /* 右から左へ放リ投げる*/
    }
    
    
    fin: M(l,s); /* 保存しておいた値を戻す　ここでは必ず　l == r になっている*/
    
    if (l-L < R-l) {                   /* 分割後の区間の短い方から再分割する*/
      if (eq_r == 0) PUSH(l+size,R);  /* 右側には必ず２個以上ある*/
      if (L < l-size && eq_l == 0) R = l-size; else goto nxt;/* 左から先にやる*/
    }
    else {
      if (eq_l == 0) PUSH(L,l-size);  /* 左側には必ず２個以上ある*/
      if (l+size < R && eq_r == 0) L = l+size; else goto nxt;/* 右から先にやる*/
    }
  }
}
