#!/usr/bin/env bash
#-------------------------------------------------------------------------------
# 1) コマンドヘルプ(-h)のエンコーディングの変更
# 2) XML標準encodingの変更
#
#  処理内容は次の通り
#   1) help/{ja-euc|ja-sjis|ja-utf8} をhelp/defaultにコピーする
#   2) mssEnc.shの内容を変更する
#  EUC環境の場合は実行する必要はない
#-------------------------------------------------------------------------------

# Encoding for command help message (-h)
#helpEnc=ja-euc
#helpEnc=ja-sjis
helpEnc=ja-utf8
#helpEnc=en

# Default encoding for XML document
#xmlEnc=euc-jp
#xmlEnc=Shift_JIS
xmlEnc=UTF-8


function show_help {
  echo '==================================================================='
  echo 'This script set encoding for command help messages'
  echo 'and XML documents.'
  echo 'Run this scirpt before "./configure"'
  echo '-------------------------------------------------------------------'
  echo 'How to use)'
  echo '  1) edit this script.'
  echo '     % vi setdocenc.sh'
  echo '  2) edit variable setting for encoding as you like.'
  echo '  3) run this script.'
  echo '     % ./setdocenc.sh'
  echo '==================================================================='
  exit
}

if [ "$helpEnc" == "" ] || [ "$xmlEnc" == "" ]
then
  show_help
fi

if [ "$helpEnc" != "en" ] && [ "$helpEnc" != "ja-euc" ] && [ "$helpEnc" != "ja-sjis" ] && [ "$helpEnc" != "ja-utf8" ]
then
  echo '## invalid "helpEnc" variable ##'
  show_help
fi

#helpファイルの変更
echo "set encoding for help messages to \"$helpEnc\"..."
rm help/default/*.h
cp -p help/$helpEnc/*.h help/default

#mssEnc.shの変更
echo "set XML default encoding to \"$xmlEnc\"..."
echo "mssXmlEnc=$xmlEnc" >mssEnc.sh

#mssEncmsg.hの変更
echo "set encoding for mssEncmsg.h to \"$helpEnc\"..."
case $helpEnc in
ja-euc )
  cp -f lib/include/musashi/mssEncmsg.h.ja-euc lib/include/musashi/mssEncmsg.h
  ;;
ja-sjis )
  cp -f lib/include/musashi/mssEncmsg.h.ja-sjis lib/include/musashi/mssEncmsg.h
  ;;
ja-utf8 )
  cp -f lib/include/musashi/mssEncmsg.h.ja-utf8 lib/include/musashi/mssEncmsg.h
  ;;
esac

#終了メッセージ
echo "completed."

