#!/bin/sh
#-------------------------------------------------------------------------------
# help,manのエンコーディングに関する更新処理
#  処理内容は次の通り
#   1) help/ja-utf8 をhelp/ja-sjis にencoding変換してコピーする
#   1) help/ja-utf8 をhelp/ja-euc にencoding変換してコピーする
#   3) help/ja-utf8 をhelp/default にコピーする
#
#  日付をチェックし、必要なファイルのみコピーする
#-------------------------------------------------------------------------------

function convHelp {
  if [ ! -e help/ja-sjis/$1 ] || [ help/ja-utf8/$1 -nt help/ja-sjis/$1 ]; then
    echo 'iconv -f utf-8 -t shift_jis <help/ja-utf8/'$1 '>help/ja-sjis/'$1
    iconv -f utf-8 -t shift_jis <help/ja-utf8/$1 >help/ja-sjis/$1
#    echo 'nkf -Es <help/ja-euc/'$1 '>help/ja-sjis/'$1
#    nkf -Es <help/ja-euc/$1 |
#    gawk '{gsub(/\\[\x80-\xff]/,"\\\\&");print $0}' >help/ja-sjis/$1
  fi

  if [ ! -e help/ja-euc/$1 ] || [ help/ja-utf8/$1 -nt help/ja-euc/$1 ]; then
    echo 'iconv -f utf-8 -t euc-jp <help/ja-utf8/'$1 '>help/ja-euc/'$1
    iconv -f utf-8 -t euc-jp <help/ja-utf8/$1 >help/ja-euc/$1
  fi

  if [ ! -e help/default/$1 ] || [ help/ja-utf8/$1 -nt help/default/$1 ]; then
    echo "cp help/ja-utf8/$1 help/default/$1"
    cp help/ja-utf8/$1 help/default/$1
  fi
}

for fname in `ls help/ja-utf8/*.h`; do
  f=${fname##*/}
  convHelp $f
done
