/**
 *  mLogger
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  message object
  * 
  *  @private
 **/
 this._message = {};

 /**
  *  timer object
  * 
  *  @private
 **/
 this._timer = {};

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
  this.resetLog();
 };

 /**
  *  setMessage
  * 
  *  @param   enum    level    // message level
  *                     memo,notice,warning,critical
  *  @param   string  path     // raise object
  *  @param   string  section  // raise section
  *  @param   string  message  // message
  * 
  *  @return  void
 **/
 this.setMessage = function(level,path,section,message)
 {
  this._message[level].push({'path' : path,'section' : section,'message' : message,'time' : this.getTimer('mutanMain')});
 };

 /**
  *  getMessage
  * 
  *  @param   enum  level  // message level
  *                   memo,notice,warning,critical
  *  @param   bool  flag   // multiple level message flag
  * 
  *  @return  array
 **/
 this.getMessage = function(level,flag)
 {
  if(!flag)
   return this._message[level];
  var mes = [];
  switch(level)
  {
   case 'memo':
    for(var i in this._message.memo)
    {
     this._message.memo[i].level = 'memo';
     mes.push(this._message.memo[i]);
    }
   case 'notice':
    for(var i in this._message.notice)
    {
     this._message.notice[i].level = 'notice';
     mes.push(this._message.notice[i]);
    }
   case 'warning':
    for(var i in this._message.warning)
    {
     this._message.warning[i].level = 'warning';
     mes.push(this._message.warning[i]);
    }
   case 'critical':
    for(var i in this._message.critical)
    {
     this._message.critical[i].level = 'critical';
     mes.push(this._message.critical[i]);
    }
   default:
  }
  return mes;
 };

 /**
  *  getMessageString
  * 
  *  @param   enum  level  // message level
  *                   memo,notice,warning,critical
  *  @param   bool  flag   // multiple level message flag
  * 
  *  @return  array
 **/
 this.getMessageString = function(level,flag)
 {
  var mes = this.getMessage(level,flag);
  var str = '<dl>';
  for(var m in mes)
   str += '<dt class="' + mes[m].level + '">' + mes[m].level + '</dt><dd>' + mes[m].path + ' : ' + mes[m].section + ' (time : ' + mes[m].time +  ')<br />' + mes[m].message + '</dd>';
  return (str + '</dl>');
 }

 /**
  *  setTimer
  * 
  *  @param   string  timerName  // target timer name
  * 
  *  @return  void
 **/
 this.setTimer = function(timerName)
 {
  var dobj = new Date();
  this._timer[timerName] = dobj.getTime();
 };

 /**
  *  getTimer
  * 
  *  @param   string  timerName  // target timer name
  * 
  *  @return  int
 **/
 this.getTimer = function(timerName)
 {
  var dobj = new Date();
  return dobj.getTime() - this._timer[timerName];
 };

 /**
  *  resetLog
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.resetLog = function()
 {
  this._message = {'memo' : [],'notice' : [],'warning' : [],'critical' : []};
  this.setTimer('mutanMain');
 };
};
