/**
 *  easyTemplateRender
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: easyTemplateRender.js,v $ $Revision: 1.4 $ $Date: 2006/12/20 04:11:45 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mController
**/
{
 /**
  *  render target object
  * 
  *  @private
 **/
 this._renderTarget = {};

 /**
  *  template cache
  * 
  *  @private
 **/
 this._tplCache = {};

 /**
  *  template directory path
  * 
  *  @private
 **/
 this._tplPath = '';

 /**
  *  template file name
  * 
  *  @private
 **/
 this._tplFile = '';

 /**
  *  left delimiter string
  * 
  *  @private
 **/
 this._leftDelimiter = '<{';

 /**
  *  right delimiter string
  * 
  *  @private
 **/
 this._rightDelimiter = '}>';

 /**
  *  assigned value
  * 
  *  @private
 **/
 this._value = {};

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
  var config = mUtils.config;
  this.setTemplatePath(config.getConfig('templatePath'));
  this.setTemplate(config.getConfig('template'));
 };

 /**
  *  setRenderTarget
  * 
  *  @param   object  targetObject  // render target object
  * 
  *  @return  void
 **/
 this.setRenderTarget = function(targetObject)
 {
  this._renderTarget = targetObject;
 };

 /**
  *  setRenderValue
  * 
  *  @param   hash  obj  // value
  *
  *  @return  void
 **/
 this.setRenderValue = function(obj)
 {
  this._value = obj;
 };

 /**
  *  setTemplatePath
  * 
  *  @param   string  path  // template directory path
  * 
  *  @return  void
 **/
 this.setTemplatePath = function(path)
 {
  this._tplPath = path;
 };

 /**
  *  setTemplate
  * 
  *  @param   string  file  // template file name
  * 
  *  @return  void
 **/
 this.setTemplate = function(file)
 {
  this._tplFile = this._tplPath + file;
  mUtils.loadFile(this._tplFile,true);
 };

 /**
  *  setDelimiter
  * 
  *  @param   string  leftDelimiter   // left delimiter string
  *  @param   string  rightDelimiter  // right delimiter string
  * 
  *  @return  void
 **/
 this.setDelimiter = function(leftDelimiter,rightDelimiter)
 {
  if(!leftDelimiter && !rightDelimiter)
   return;
  this._leftDelimiter  = leftDelimiter;
  this._rightDelimiter = rightDelimiter;
 };

 /**
  *  display
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.display = function()
 {
  var file = {};
  file[this._tplFile] = this._tplFile;
  mUtils.waitResponse(this._tplCache,file,this._parseTemplate,this);
 };

 /**
  *  _parseTemplate
  * 
  *  @param   mRender  myObj
  * 
  *  @return  void
 **/
 this._parseTemplate = function(myObj)
 {
  var tpl = myObj._tplCache[myObj._tplFile];
  var val = myObj._value;
  var ldl = myObj._leftDelimiter;
  var rdl = myObj._rightDelimiter;
  for(var i in val)
  {
   var reg = new RegExp((ldl + i + rdl).replace(/([.*+?^${}()|[\]\/\\])/g,'\\$1'),'g');
   tpl = tpl.replace(reg,val[i]);
  }
  myObj._renderTarget.innerHTML = tpl;
 };
};
