/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.ssuif.swt.builder;

import java.util.Iterator;
import jp.gr.java_conf.dev240k.util.ssuif.model.IButtonModel;
import jp.gr.java_conf.dev240k.util.ssuif.model.event.ISelectionListener;
import jp.gr.java_conf.dev240k.util.ssuif.swt.AbstractControlBuilder;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlFactory;
import jp.gr.java_conf.dev240k.util.ssuif.swt.builder.SelectionListenerAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractButtonBuilder
extends AbstractControlBuilder {
    protected Button createButton(IButtonModel buttonModel, Composite parent) {
        IControlFactory controlFactory = super.getControlFactory();
        Button button = controlFactory != null ? controlFactory.createButton(parent) : new Button(parent, 0);
        String text = buttonModel.getText();
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Control createControl(Object model, Composite parent) {
        IButtonModel buttonModel = (IButtonModel)model;
        Button button = this.createButton(buttonModel, parent);
        Iterator it = buttonModel.getSelectionListenerList().iterator();
        while (it.hasNext()) {
            ISelectionListener listener = (ISelectionListener)it.next();
            button.addSelectionListener((SelectionListener)new SelectionListenerAdapter(listener));
        }
        return button;
    }
}

