/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.ssuif.swt.builder;

import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.util.ssuif.model.ITabFolderModel;
import jp.gr.java_conf.dev240k.util.ssuif.model.ITabItemModel;
import jp.gr.java_conf.dev240k.util.ssuif.swt.AbstractControlBuilder;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class AbstractTabFolderBuilder
extends AbstractControlBuilder {
    protected Composite createTabFolder(ITabFolderModel tabFolderModel, Composite parent) {
        IControlFactory controlFactory = super.getControlFactory();
        CTabFolder tabFolder = controlFactory != null ? controlFactory.createCTabFolder(parent) : new CTabFolder(parent, 0);
        return tabFolder;
    }

    private CTabItem createCTabItem(ITabItemModel tabItemModel, CTabFolder tabFolder) {
        IControlFactory controlFactory = super.getControlFactory();
        CTabItem tabItem = controlFactory != null ? controlFactory.createCTabItem(tabFolder) : new CTabItem(tabFolder, 0);
        return tabItem;
    }

    private TabItem createTabItem(ITabItemModel tabItemModel, TabFolder tabFolder) {
        IControlFactory controlFactory = super.getControlFactory();
        TabItem tabItem = controlFactory != null ? controlFactory.createTabItem(tabFolder) : new TabItem(tabFolder, 0);
        return tabItem;
    }

    protected Item createTabItem(ITabItemModel tabItemModel, Composite tabFolder) {
        if (tabFolder instanceof CTabFolder) {
            CTabItem tabItem = this.createCTabItem(tabItemModel, (CTabFolder)tabFolder);
            tabItem.setText(tabItemModel.getName());
            Object childModel = tabItemModel.getControl();
            Control childControl = super.createChildControl(childModel, tabFolder);
            tabItem.setControl(childControl);
            return tabItem;
        }
        if (tabFolder instanceof TabFolder) {
            TabItem tabItem = this.createTabItem(tabItemModel, (TabFolder)tabFolder);
            tabItem.setText(tabItemModel.getName());
            Object childModel = tabItemModel.getControl();
            Control childControl = super.createChildControl(childModel, tabFolder);
            tabItem.setControl(childControl);
            return tabItem;
        }
        return null;
    }

    protected void addTabItems(ITabFolderModel tabFolderModel, Composite tabFolder) {
        List list = tabFolderModel.getTabItemList();
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ITabItemModel tabItemModel = (ITabItemModel)it.next();
            this.createTabItem(tabItemModel, tabFolder);
        }
    }

    public Control createControl(Object model, Composite parent) {
        ITabFolderModel tabFolderModel = (ITabFolderModel)model;
        Composite tabFolder = this.createTabFolder(tabFolderModel, parent);
        this.addTabItems(tabFolderModel, tabFolder);
        return tabFolder;
    }
}

