/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import jp.gr.java_conf.dev240k.util.dom.DocumentBuilderWrapper;
import jp.gr.java_conf.dev240k.util.dom.NodeWrapper;
import jp.gr.java_conf.dev240k.util.loader.DefaultPluginExceptionListener;
import jp.gr.java_conf.dev240k.util.loader.DirectoryFileFilter;
import jp.gr.java_conf.dev240k.util.loader.ExtensionPointWrapper;
import jp.gr.java_conf.dev240k.util.loader.ExtensionWrapper;
import jp.gr.java_conf.dev240k.util.loader.IPluginExceptionListener;
import jp.gr.java_conf.dev240k.util.loader.InvalidExtensionConfigurationException;
import jp.gr.java_conf.dev240k.util.loader.JarFilenameFilter;
import jp.gr.java_conf.dev240k.util.loader.PluginException;
import jp.gr.java_conf.dev240k.util.loader.PluginExceptionListenerException;
import jp.gr.java_conf.dev240k.util.loader.PluginIOException;
import jp.gr.java_conf.dev240k.util.loader.PluginManagerInnerException;
import jp.gr.java_conf.dev240k.util.loader.PluginManagerUtil;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.SAXException;

public class PluginManager {
    public static final String PLUGIN_XML = "plugin.xml";
    private static final String TAG_PLUGIN = "plugin";
    private static final String TAG_EXTENSION = "extension";
    private static final String ATTR_EXTENSION_ID = "id";
    private static final String ATTR_EXTENSION_POINT = "point";
    private IPluginExceptionListener pluginExceptionListener = null;
    private Map additionalExtensionPointMap = new HashMap();

    public IPluginExceptionListener getPluginExceptionListener() {
        return this.pluginExceptionListener;
    }

    public void setPluginExceptionListener(IPluginExceptionListener pluginExceptionListener) {
        this.pluginExceptionListener = pluginExceptionListener;
    }

    public ExtensionPointWrapper getExtensionPoint(String extensionPointId) {
        ExtensionPointWrapper extensionPoint = (ExtensionPointWrapper)this.additionalExtensionPointMap.get(extensionPointId);
        if (extensionPoint == null) {
            extensionPoint = new ExtensionPointWrapper();
        }
        if (PluginManagerUtil.isExtensionRegistryAvailable()) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null) {
                if (LoggerUtil.isDebugEnabled(this.getClass())) {
                    LoggerUtil.debug(this.getClass(), (String)PluginManagerUtil.getMessage("message.debug.extensionRegistryAvailable"));
                }
                extensionPoint.setExtensionPoint(registry.getExtensionPoint(extensionPointId));
            } else if (LoggerUtil.isDebugEnabled(this.getClass())) {
                LoggerUtil.debug(this.getClass(), (String)PluginManagerUtil.getMessage("message.debug.extensionRegistryNotAvailable"));
            }
        } else if (LoggerUtil.isDebugEnabled(this.getClass())) {
            LoggerUtil.debug(this.getClass(), (String)PluginManagerUtil.getMessage("message.debug.extensionRegistryNotAvailable"));
        }
        return extensionPoint;
    }

    private void callPluginExceptionListener(String pluginPath, Exception e) throws PluginExceptionListenerException {
        IPluginExceptionListener listener = this.pluginExceptionListener == null ? new DefaultPluginExceptionListener() : this.pluginExceptionListener;
        listener.exceptionThrown(pluginPath, "", e);
    }

    private void parseRootNode(ClassLoader loader, NodeWrapper rootNode) {
        NodeWrapper pluginNode = rootNode.getFirstNode(TAG_PLUGIN);
        List extensionNodeList = pluginNode.getNodeList(TAG_EXTENSION);
        Iterator it = extensionNodeList.iterator();
        while (it.hasNext()) {
            NodeWrapper extensionNode = (NodeWrapper)it.next();
            String extensionPointId = extensionNode.getAttribute(ATTR_EXTENSION_POINT);
            if (extensionPointId == null) {
                String[] args = new String[]{extensionNode.getAttribute(ATTR_EXTENSION_ID)};
                LoggerUtil.warn(this.getClass(), (String)PluginManagerUtil.getMessage("message.warn.extensionPointNotSpecified", args));
                continue;
            }
            ExtensionPointWrapper extensionPoint = (ExtensionPointWrapper)this.additionalExtensionPointMap.get(extensionPointId);
            if (extensionPoint == null) {
                extensionPoint = new ExtensionPointWrapper();
                this.additionalExtensionPointMap.put(extensionPointId, extensionPoint);
            }
            extensionPoint.addExtensionWrapper(new ExtensionWrapper(loader, extensionNode));
        }
    }

    private NodeWrapper parseInputStream(InputStream is) throws InvalidExtensionConfigurationException, PluginIOException {
        NodeWrapper rootNode;
        try {
            rootNode = DocumentBuilderWrapper.getInstance().parse(is);
        }
        catch (SAXException e) {
            throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
        }
        catch (ParserConfigurationException e) {
            throw new PluginManagerInnerException(e);
        }
        catch (IOException e) {
            throw new PluginIOException(PluginManagerUtil.getMessage("message.error.PluginConfigurationIOError"), e);
        }
        return rootNode;
    }

    private InputStream loadPluginConfig(ClassLoader loader) throws PluginIOException {
        InputStream is = loader.getResourceAsStream(PLUGIN_XML);
        if (is == null) {
            String[] args = new String[]{PLUGIN_XML};
            throw new PluginIOException(PluginManagerUtil.getMessage("message.error.pluginConfigNotFound", args));
        }
        if (LoggerUtil.isTraceEnabled(this.getClass())) {
            String[] args = new String[]{loader.getResource(PLUGIN_XML).toString()};
            LoggerUtil.trace(this.getClass(), (String)PluginManagerUtil.getMessage("message.trace.loadPluginConfig", args));
        }
        return is;
    }

    private void loadExtensions(InputStream isPluginConfig, ClassLoader loader) throws PluginIOException, InvalidExtensionConfigurationException {
        NodeWrapper rootNode = this.parseInputStream(isPluginConfig);
        this.parseRootNode(loader, rootNode);
    }

    private void loadExtensions(URL url, ClassLoader parentLoader) throws PluginException {
        URL[] urls = new URL[]{url};
        URLClassLoader configLoader = new URLClassLoader(urls, null);
        InputStream is = this.loadPluginConfig(configLoader);
        URLClassLoader classLoader = new URLClassLoader(urls, parentLoader);
        this.loadExtensions(is, (ClassLoader)classLoader);
    }

    public void load(String rootDirectory, ClassLoader classLoader) throws IOException, PluginExceptionListenerException {
        String[] args;
        URL url;
        File rootDir = new File(rootDirectory);
        if (LoggerUtil.isDebugEnabled(this.getClass())) {
            String[] args2 = new String[]{rootDirectory};
            LoggerUtil.debug(this.getClass(), (String)PluginManagerUtil.getMessage("message.debug.searchPluginsInDirectory", args2));
        }
        File[] dirArray = rootDir.listFiles(new DirectoryFileFilter());
        int i = 0;
        while (i < dirArray.length) {
            url = dirArray[i].getCanonicalFile().toURI().toURL();
            if (LoggerUtil.isTraceEnabled(this.getClass())) {
                args = new String[]{url.getPath()};
                LoggerUtil.trace(this.getClass(), (String)PluginManagerUtil.getMessage("message.trace.loadFromDirectory", args));
            }
            try {
                this.loadExtensions(url, classLoader);
            }
            catch (PluginException e) {
                this.callPluginExceptionListener(dirArray[i].getName(), e);
            }
            ++i;
        }
        dirArray = rootDir.listFiles(new JarFilenameFilter());
        i = 0;
        while (i < dirArray.length) {
            url = dirArray[i].getCanonicalFile().toURI().toURL();
            if (LoggerUtil.isTraceEnabled(this.getClass())) {
                args = new String[]{url.getPath()};
                LoggerUtil.trace(this.getClass(), (String)PluginManagerUtil.getMessage("message.trace.loadFromJar", args));
            }
            try {
                this.loadExtensions(url, classLoader);
            }
            catch (PluginException e) {
                this.callPluginExceptionListener(dirArray[i].getName(), e);
            }
            ++i;
        }
    }

    public void load(String rootDirectory) throws PluginExceptionListenerException, IOException {
        this.load(rootDirectory, ClassLoader.getSystemClassLoader());
    }

    public void load(ClassLoader loader) throws PluginExceptionListenerException {
        try {
            if (LoggerUtil.isDebugEnabled(this.getClass())) {
                LoggerUtil.debug(this.getClass(), (String)PluginManagerUtil.getMessage("message.debug.searchPluginsInClassLoader"));
            }
            InputStream is = this.loadPluginConfig(loader);
            this.loadExtensions(is, loader);
        }
        catch (PluginException e) {
            this.callPluginExceptionListener("", e);
        }
    }
}

