/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.IValueFormatter;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;

public class BasicValueFormatter
implements IValueFormatter {
    private NumberFormat nf = NumberFormat.getInstance();

    private String formatSingleValueAsFloat(Double d) {
        return this.nf.format(d);
    }

    private String formatSingleValueToBitString(int numSys, Double d) {
        String ret;
        int sign = d >= 0.0 ? 1 : -1;
        int iVal = sign * d.intValue();
        if (numSys == 2) {
            ret = Integer.toBinaryString(iVal);
        } else if (numSys == 3) {
            ret = Integer.toOctalString(iVal);
        } else if (numSys == 4) {
            ret = Integer.toHexString(iVal);
        } else {
            return "";
        }
        if (sign == -1) {
            ret = "-" + ret;
        }
        return ret;
    }

    private String formatSingleValueAsTime(Double d) {
        StringBuffer ret = new StringBuffer("");
        if (d < 0.0) {
            ret.append("-");
        }
        double dd = Math.abs(d);
        DecimalFormat hourFormat = new DecimalFormat("00");
        DecimalFormat secondFormat = new DecimalFormat("00.###");
        double hh = Math.floor(dd / 3600.0);
        ret.append(hourFormat.format(hh));
        ret.append(":");
        double mm = Math.floor((dd -= hh * 3600.0) / 60.0);
        ret.append(hourFormat.format(mm));
        ret.append(":");
        double ss = dd - mm * 60.0;
        ret.append(secondFormat.format(ss));
        return ret.toString();
    }

    private String formatSingleValueAsDate(Double d) {
        StringBuffer ret = new StringBuffer("");
        long timeInMillis = (long)(8.64E7 * d);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMillis);
        DecimalFormat format = new DecimalFormat("00");
        int year = cal.get(1);
        ret.append(year);
        ret.append("/");
        int month = cal.get(2) + 1;
        ret.append(format.format(month));
        ret.append("/");
        int day = cal.get(5);
        ret.append(format.format(day));
        return ret.toString();
    }

    private String formatSingleValue(int numSys, Double d) {
        if (d.isInfinite() || d.isNaN()) {
            return d.toString();
        }
        if (numSys == 1) {
            return this.formatSingleValueAsFloat(d);
        }
        if (numSys == 2 || numSys == 3 || numSys == 4) {
            return this.formatSingleValueToBitString(numSys, d);
        }
        if (numSys == 5) {
            return this.formatSingleValueAsTime(d);
        }
        if (numSys == 6) {
            return this.formatSingleValueAsDate(d);
        }
        return this.formatSingleValueAsFloat(d);
    }

    public String format(ValueElement element) {
        String ret;
        List valueList = element.getValueList();
        if (valueList.size() <= 0) {
            ret = "";
        } else if (valueList.size() == 1) {
            ret = this.formatSingleValue(element.getNumberSystem(), (Double)valueList.get(0));
        } else {
            StringBuffer buf = new StringBuffer();
            Iterator it = valueList.iterator();
            Double d = (Double)it.next();
            buf.append(this.formatSingleValue(element.getNumberSystem(), d));
            while (it.hasNext()) {
                buf.append(", ");
                d = (Double)it.next();
                buf.append(this.formatSingleValue(element.getNumberSystem(), d));
            }
            ret = buf.toString();
        }
        return ret;
    }
}

