/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IBufferElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.BufferParserFactory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.IBufferParser;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;

public class BufferElement
implements IBufferElement {
    private static final String STR_INITIAL = "0";
    private StringBuffer buffer = new StringBuffer("0");
    private int numberSystem = 1;
    private Unit unit;

    private IBufferParser getBufferParser() {
        return BufferParserFactory.getParser();
    }

    public StringBuffer getBuffer() {
        return new StringBuffer(this.buffer);
    }

    public void setBuffer(StringBuffer buffer) {
        this.setBuffer(buffer, this.numberSystem);
    }

    public void setBuffer(StringBuffer buffer, int numSys) {
        IBufferParser parser = this.getBufferParser();
        if (parser.validateBuffer(buffer, numSys)) {
            this.buffer = new StringBuffer(buffer);
            this.numberSystem = numSys;
        }
    }

    public int getNumberSystem() {
        return this.numberSystem;
    }

    public void setNumberSystem(int numSys) {
        IBufferParser parser = this.getBufferParser();
        if (parser.validateBuffer(this.buffer, numSys)) {
            this.numberSystem = numSys;
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public IValueElement toValueElement() {
        IBufferParser parser = this.getBufferParser();
        ValueElement element = parser.parseBuffer(this.buffer, this.numberSystem);
        element.setUnit(this.unit);
        return element;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.buffer.toString());
        if (this.unit != null) {
            buffer.append(" ");
            buffer.append(this.unit.getSign());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BufferElement)) {
            return false;
        }
        if (this.unit != ((BufferElement)obj).getUnit()) {
            return false;
        }
        return this.buffer.equals(((BufferElement)obj).getBuffer());
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }
}

