/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.Calculator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElementModifyListener;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IAction;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IDyadicOperator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.InitialElementFactory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.MixedCalcPluginManager;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.IUnitManager;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;

public class CalculatorControler {
    private Calculator calculator;
    private MixedCalcPluginManager mixedCalcPluginManager;
    private IUnitManager unitManager;

    public CalculatorControler() {
        this.initialize();
    }

    private void initialize() {
        if (LoggerUtil.isDebugEnabled(this.getClass())) {
            LoggerUtil.debug(this.getClass(), (String)"initialize.");
        }
        this.calculator = new Calculator();
        this.calculator.setInitialElementFactory(new InitialElementFactory());
        this.calculator.initializeCalculator();
    }

    public void setMixedCalcPluginManager(MixedCalcPluginManager manager) {
        this.mixedCalcPluginManager = manager;
    }

    public MixedCalcPluginManager getMixedCalcPluginManager() {
        return this.mixedCalcPluginManager;
    }

    public void setUnitManager(IUnitManager manager) {
        this.unitManager = manager;
    }

    public IUnitManager getUnitManager() {
        return this.unitManager;
    }

    public void addElementModifyListener(IElementModifyListener listener) {
        this.calculator.addElementModifyListener(listener);
    }

    public Object getProperty(String key) {
        return this.calculator.getProperty(key);
    }

    public void setProperty(String key, Object property) {
        this.calculator.setProperty(key, property);
    }

    public void invokeModifyListener() {
        this.calculator.invokeModifyListener();
    }

    public IElement getResult() {
        return this.calculator.getLastValue();
    }

    public IDyadicOperator getOperator() {
        return this.calculator.getOperator();
    }

    public void execute(IAction action) {
        this.calculator.executeAction(action);
    }
}

