/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.AbstractMixedCalcLibraryTestCase;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.RatedUnit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitManager;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import org.xml.sax.SAXException;

public class UnitManagerTest
extends AbstractMixedCalcLibraryTestCase {
    private UnitManager unitManager = null;
    private UnitSet unitSet = null;
    private UnitCategory unitCategoryLength = null;
    private Unit unitMeter = null;
    private Unit unitKilometer = null;
    private Unit unitMillimeter = null;
    private UnitCategory unitCategoryMass = null;
    private Unit unitKilogram = null;
    private UnitCategory unitCategoryArea = null;
    private Unit unitMeter2 = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.unitManager = new UnitManager();
        this.unitManager.load();
        this.unitSet = this.unitManager.getUnitSet();
        this.unitCategoryLength = (UnitCategory)this.unitSet.getUnitCategoryList().get(1);
        this.unitMeter = (Unit)this.unitCategoryLength.getUnitList().get(0);
        this.unitKilometer = (Unit)this.unitCategoryLength.getUnitList().get(1);
        this.unitMillimeter = (Unit)this.unitCategoryLength.getUnitList().get(3);
        this.unitCategoryMass = (UnitCategory)this.unitSet.getUnitCategoryList().get(2);
        this.unitKilogram = (Unit)this.unitCategoryMass.getUnitList().get(0);
        this.unitCategoryArea = (UnitCategory)this.unitSet.getUnitCategoryList().get(4);
        this.unitMeter2 = (Unit)this.unitCategoryArea.getUnitList().get(0);
    }

    private void validateDefaultUnitSet(UnitSet unitSet) {
        List unitCategoryList = unitSet.getUnitCategoryList();
        AbstractMixedCalcLibraryTestCase.assertEquals((int)7, (int)unitCategoryList.size());
        UnitCategory unitCategoryNone = (UnitCategory)unitCategoryList.get(0);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"none", (String)unitCategoryNone.getName());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)0, (int)unitCategoryNone.getDimensionOfLength());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)0, (int)unitCategoryNone.getDimensionOfMass());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)0, (int)unitCategoryNone.getDimensionOfTime());
        UnitCategory unitCategoryLength = (UnitCategory)unitCategoryList.get(1);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"length", (String)unitCategoryLength.getName());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)1, (int)unitCategoryLength.getDimensionOfLength());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)0, (int)unitCategoryLength.getDimensionOfMass());
        AbstractMixedCalcLibraryTestCase.assertEquals((int)0, (int)unitCategoryLength.getDimensionOfTime());
        List unitList = unitCategoryLength.getUnitList();
        AbstractMixedCalcLibraryTestCase.assertEquals((int)4, (int)unitList.size());
        Unit unitMeter = (Unit)unitList.get(0);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"m", (String)unitMeter.getName());
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"m", (String)unitMeter.getSign());
        AbstractMixedCalcLibraryTestCase.assertEquals((double)1.0, (double)unitMeter.getRate(), (double)0.001);
        Unit unitMilliMeter = (Unit)unitList.get(3);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"mm", (String)unitMilliMeter.getName());
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"mm", (String)unitMilliMeter.getSign());
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.001, (double)unitMilliMeter.getRate(), (double)1.0E-6);
    }

    public void testLoad() {
        this.validateDefaultUnitSet(this.unitSet);
    }

    public void testSave() throws IOException, SAXException, IntrospectionException {
    }

    public void testSaveString() throws IOException, SAXException, IntrospectionException {
        String path = "unit_test.xml";
        File file = new File(path);
        LoggerUtil.info(((Object)((Object)this)).getClass(), (String)("output path: " + file.getAbsolutePath()));
        this.unitManager.save(path);
    }

    public void testConvertUnit() {
        LoggerUtil.info(((Object)((Object)this)).getClass(), (String)("--- DO " + ((Object)((Object)this)).getClass().getSimpleName() + "#" + this.getName() + "()"));
        double[] val1 = new double[]{5.0, 0.2};
        ValueElement value1 = new ValueElement(val1);
        value1.setUnit(this.unitMillimeter);
        ValueElement value2 = this.unitManager.convertUnit(value1, this.unitMeter);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.005, (double)((Double)value2.getValueList().get(0)), (double)5.0E-6);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)2.0E-4, (double)((Double)value2.getValueList().get(1)), (double)2.0000000000000002E-7);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"m", (String)value2.getUnit().getName());
        AbstractMixedCalcLibraryTestCase.assertEquals((double)5.0, (double)((Double)value1.getValueList().get(0)), (double)5.0);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.2, (double)((Double)value1.getValueList().get(1)), (double)0.2);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"mm", (String)value1.getUnit().getName());
        ValueElement value3 = this.unitManager.convertUnit(value2, this.unitKilogram);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.005, (double)((Double)value3.getValueList().get(0)), (double)5.0E-6);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)2.0E-4, (double)((Double)value3.getValueList().get(1)), (double)2.0000000000000002E-7);
        AbstractMixedCalcLibraryTestCase.assertEquals((String)"kg", (String)value3.getUnit().getName());
    }

    public void testMultiplyUnits() {
        RatedUnit ratedUnit = this.unitManager.multiplyUnits(this.unitMeter, this.unitKilometer);
        AbstractMixedCalcLibraryTestCase.assertEquals((Object)this.unitMeter2, (Object)ratedUnit.unit);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)1000.0, (double)ratedUnit.rate, (double)0.001);
    }

    public void testSearchUnitIntIntIntDouble() {
        Unit unit = this.unitManager.searchUnit(1, 0, 0, 100.0);
        AbstractMixedCalcLibraryTestCase.assertEquals((Object)this.unitKilometer, (Object)unit);
        unit = this.unitManager.searchUnit(1, 0, 1, 0.01);
        AbstractMixedCalcLibraryTestCase.assertNull((Object)unit);
    }

    public void testSearchUnitCategoryIntIntInt() {
        UnitCategory unitCategory = this.unitManager.searchUnitCategory(0, 1, 0);
        AbstractMixedCalcLibraryTestCase.assertEquals((Object)this.unitCategoryMass, (Object)unitCategory);
        unitCategory = this.unitManager.searchUnitCategory(0, 2, 0);
        AbstractMixedCalcLibraryTestCase.assertNull((Object)unitCategory);
    }
}

