<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("_my_calendar.php");

	if (isset($_GET['mode'])) {
		$_SESSION['calendar_mode'] = $_GET['mode'];
	}
	$arg_pool_prefix = "calendar_schedule";

	$http_arg = array();
	$http_arg['y'] = '';
	$http_arg['m'] = '';
	$http_arg['d'] = '';
	$http_arg['cat'] = '';
	$http_arg['key'] = '';

	_GET_to_http_arg_pool($http_arg, $arg_pool_prefix, 'y,m,key');

	$category = $http_arg['cat'];
	$keystring = $http_arg['key'];

	$year = $http_arg['y'];
	$month = $http_arg['m'];
	if ($year == '') {
		$year = date("Y");
	}
	if ($month == '') {
		$month = date("n");
	}

	html_header(HTML_TITLE);
	page_header();
	contents_header();

	$prev_year_m = $month;
	$prev_year_y = $year - 1;
	$next_year_m = $month;
	$next_year_y = $year + 1;
	if ($month == 1) {
		$prev_month_m = 12;
		$prev_month_y = $year - 1;
		$next_month_m = $month + 1;
		$next_month_y = $year;
	} elseif ($month == 12) {
		$prev_month_m = $month - 1;
		$prev_month_y = $year;
		$next_month_m = 1;
		$next_month_y = $year + 1;
	} else {
		$prev_month_m = $month - 1;
		$prev_month_y = $year;
		$next_month_m = $month + 1;
		$next_month_y = $year;
	}
	$con = my_mysql_connect(_DB_SCHEMA);
?>
<div id="calendar_body">
<form method="POST" name="filter_form" action="<?= $_SERVER['SCRIPT_NAME'] ?>?<?= query_from_http_arg_pool($http_arg) ?>">
<div id="calendar_category_select" class="block_left">
<?php
	filter_category_select($category, $_SESSION['current_id'], $http_arg);
?>
</div>
<div id="filter_key_select" class="block_left left_mini_margin">
<?php
	filter_key_select($keystring, $http_arg);
?>
</div>
<div id="filter_mode_change" class="block_left left_mini_margin">
<?php
	filter_mode_change();
?>
</div>
</form>
<div id="calendar_main">
	<table>
	<caption><span class="calendar_caption_ym"><?= $year ?>年</span>
		<span id="calendar_ymd_change">
		<ul>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= date('Y') ?>&m=<?= date('n') ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">今年</a></li>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $prev_year_y ?>&m=<?= $prev_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">←前年</a></li>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $next_year_y ?>&m=<?= $next_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">→次年</a></li>
		</ul>
		</span>
		<span id="calendar_ymd_select">
		<script language="JavaScript">
		<!--
		function SelectionYear(form, sel)
		{
			for (i = 0; i < sel.options.length; i++) {
				if (sel.options[i].selected == true) {
					window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?y=" + escape(sel.options[i].value) + "&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>";
				}
			}
		}
		//-->
		</script>
		<select name="ChangeYear" onChange="SelectionYear(this.form, this)">
	<?php
			$endYY = date("Y") + 10;
			for ($yy = _CALENDAR_SELECT_FIRST_YEAR; $yy <= $endYY; $yy++) {
	?>
		<option value="<?= $yy ?>"<?= $yy == $year ? ' selected' : '' ?>><?= $yy ?>
	<?php
			}
	?>
		</select>年
		</span>
	</caption>
	<tr><td>
		<table class="year_calendar_frame">
		<tr>
	<?php
		for ($month=1; $month<=12; $month++) {
			if ($month==4 || $month==7 || $month==10) {
	?>
		</tr>
		<tr>
	<?php
			}
	?>
		<td class="year_calendar_frame_month">
	<?php
			calendar_month($year, $month, $_SESSION['current_id'], $category, $keystring, "calendar_tbl_mini");
	?>
		</td>
	<?php
		}
	?>
		</tr>
		</table>
	</td>
	<td class="year_calendar_separator"><div class="year_calendar_separator_line"></div></td>
	<td>
		<table class="year_calendar_frame">
		<tr>
	<?php
		$year++;
		for ($month=1; $month<=12; $month++) {
			if ($month==4 || $month==7 || $month==10) {
	?>
		</tr>
		<tr>
	<?php
			}
	?>
		<td class="year_calendar_frame_month">
	<?php
			calendar_month($year, $month, $_SESSION['current_id'], $category, $keystring, "calendar_tbl_mini");
	?>
		</td>
	<?php
		}
	?>
		</tr>
		</table>
	</td></tr>
	</table>
</div>

</div>
<?php
	page_footer();
	html_footer();
	exit();
?>
