<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	$_SESSION['current_permit_type'] = "w";		// is_write_permit()でFalseにならないように
	require("../__common__/include-common-mp-list.php");
?>
<?php
	$table_name_view = "v_bbs";
	$table_name = "m_bbs";
	$id_item = "id_bbs";
	$must_item = "c_title";

	$mp_list_arg = array();
	$mp_list_arg['account_id']	= "ALL";		// 共通
	$mp_list_arg['table_name_view']		= "v_bbs";
	$mp_list_arg['id_item']		= "id_bbs";
	$mp_list_arg['must_item']	= "c_subject";
	$mp_list_arg['template_view']	= "list-my-template.php";
	$mp_list_arg['add_filter']	= "list-my-add-filter.php";
//	$mp_list_arg['input_new']	= "no";
	$mp_list_arg['edit_list_all']	= "no";
//	$mp_list_arg['use_privacy']	= "yes";

	$mp_list_arg['sql_create_callback']	= "my_mp_list_sql_create";

	$item_tbl = array();
	$item_tbl[] = array(	"表示名"=>"カテゴリ",	"列名"=>"id_category", "http_arg_GET名"=>"cat",
				"type"=>"select", "参照テーブル"=>"m_category", "参照テーブル表示列"=>"c_categoryName",
				"参照テーブル表示順"=>"c_categoryDisplayOrder", "参照テーブル表示色"=>"c_categoryDisplayColor");
	$item_tbl[] = array(	"表示名"=>"タイトル",	"列名"=>"c_subject",
				"type"=>"text", "size"=>40, "ime-mode"=>"active", "文字検索"=>"Y");
	$item_tbl[] = array(	"表示名"=>"本文",	"列名"=>"c_body_strip_tags",
				"type"=>"textarea", "cols"=>70, "rows"=>3, "文字検索"=>"Y");
				//↑文字検索は、c_body_strip_tagsに対して行う(HTMLタグ内文字を検索しない)

	$order_tbl = array();
	$order_tbl[] = array(   "表示名"=>"返信最新順", "get_order_name"=>"rep",
				"order_by"=>"c_reply_lasttime desc");		/* default */
	$order_tbl[] = array(   "表示名"=>"スレッド最新順", "get_order_name"=>"new",
				"order_by"=>"c_registtime desc");

	$http_arg = array();

	$http_arg['pl'] = PAGE_LINE_DEFAULT;		// mp_list 必須
	$http_arg['sort'] = '';				// mp_list 必須
	$http_arg['cat'] = '';				// mp_list 必須
	$http_arg['key'] = '';				// mp_list 必須
	$http_arg['ac'] = '';				// 投稿者フィルタ
	$http_arg['del'] = '';				// 削除投稿表示/非表示

	_GET_to_http_arg_pool($http_arg, $table_name, 'sort,key,pl');

	if ($_GET['body'].'' <> '') {
		$_SESSION['bbs_body_view'] = $_GET['body'];
	}

	html_header(HTML_TITLE, '', '#ffffff');
	page_header();
	contents_header();
	mp_list_view($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
	page_footer();
	html_footer();
	exit();
// ****************************************************************
function my_mp_list_sql_create($account_id, $table_name, $item_tbl, $order_tbl, $sortorder, $keystring, $sel_filter, $use_privacy, $add_where="") {
// ****************************************************************
	if ($keystring == "") {
		$sql = "select * from ".$table_name." where p_id_bbs = 0 and c_delete <> 999";	// 444,888は検索対象
	} else {
		$sql_in = "select distinct case when p_id_bbs = 0 then id_bbs else p_id_bbs end from ".$table_name." where c_delete <> 999";
		$select_item = array();
		foreach ($item_tbl as $id=>$item) {
			if ($item['文字検索'] == "Y") {
				$select_item[] = $item['列名'];
			}
		}
		if (count($select_item) > 0) {
			$sql_in .= ' and ( '.query_and_or($select_item, $keystring).' )';
		}
		$sql = "select * from ".$table_name." where id_bbs in ( " . $sql_in . " )";
	}
	foreach ($sel_filter as $id=>$filter) {
		if ($filter['data'] <> '') {
			$sql .= " and " . $filter['colname'] . " = '" . $filter['data'] . "'";
		}
	}
	if ($add_where <> "") {
		$sql .= " and " . $add_where;
	}
	foreach ($order_tbl as $id=>$item) {
		if ($item['get_order_name'] == $sortorder) {
			$order_item = $item['order_by'];
		}
	}
	$sql .= " order by ".$order_item;
	$_SESSION['bbs_list_sql'] = $sql;
	return($sql);
}
