<?php
function email_view_frame($rec, $table_width=288) {
	if ($rec['c_host_pop3'].'' == '') return;
?>
	<div class="email_thumbnail">
	<table class="email_list" style="width: <?= $table_width ?>px; border-color: <?= $rec['c_displayColor'] ?>; background-color: <?= $rec['c_displayColor'] ?>;">
	<tr><th class="email_list_title">
		<a href="mail_list.php?id=<?= $rec['id_email'] ?>"><?= $rec['c_name'] ?></a>
	</th></tr>
	<tr><td id="email_<?= $rec['id_email'] ?>" class="email_list_body" style="border-color: <?= $rec['c_displayColor'] ?>;"><br><br><br><br><br></td></tr>
	</table>
	</div>
<?php
}
function email_view_list($rec, $view_max=10, $read_max=100) {
	if ($rec['c_host_pop3'].'' == '') return;
?>
<div id="em_index_list_box">
<?php
	$id_email = $rec['id_email'];
	session_start();
	if (!($_SESSION['email_get'][$id_email]['get'])) {
		session_write_close();
		$account = array(
			'host' => $rec['c_host_pop3'],
			'port' => $rec['c_port_pop3'],
			'username' => $rec['c_username'],
			'password' => $rec['c_password'],
		);
		if (!($msg_num = email_get_list($account, $id_email, $read_max))) {
			return;
		}
	} else {
		session_write_close();
	}
	session_start();
	$msg_num = $_SESSION['email_get'][$id_email]['msg_num'];
?>
<div id="em_list_msg_num">
新着メッセージ： <span style="font-weight:bold;"><?= $msg_num ?></span> 件
<?php	if ($msg_num > $view_max) { ?>
(最新の <span style="font-weight:bold;"><?= $view_max ?></span> 件を表示)
<?php	} ?>
</div>
<table id="em_msg_list">
<tbody>
<?php
	if ($msg_num > $view_max) {
		$num_limit = $msg_num - $view_max + 1;
	} else {
		$num_limit = 1;
	}
	for ($ix=$msg_num; $ix>=$num_limit; $ix--) {
		$from = $_SESSION['email_get'][$id_email]['from'][$ix];
		$subject = $_SESSION['email_get'][$id_email]['subject'][$ix];
		$date = $_SESSION['email_get'][$id_email]['date'][$ix];
?>
	<tr>
	<td class="em_msg_list_from"><a title="<?= my_htmlspecialchars($from) ?>"><?= my_htmlspecialchars(left_short(strip_tags($from), 10)) ?></a></td>
	<td class="em_msg_list_subject"><a href="mail_msg.php?id=<?= $id_email ?>&no=<?= $ix ?>" target="_blank"><?= my_htmlspecialchars($subject) ?></a></td>
	<td class="em_msg_list_date"><?= date('m/d H:i', $date) ?></td>
	</tr>
<?php
	}
	session_write_close();
?>
</tbody>
</table>
</div>
<?php
}
function email_get_list($account, $id_email, $read_max=100) {
	require_once('Net/POP3.php');
	$pop3 = new Net_POP3();
	if (!($pop3->connect($account['host'], $account['port']))) {
		error_msg('メールサーバー接続エラー<br><br><br>');
		return false;
	}
	if (($pop3->login($account['username'], $account['password'])) != 1) {
		error_msg('メールサーバーログインエラー<br><br><br>');
		return false;
	}
	if (!($msg_num = $pop3->numMsg())) {
		error_msg('受信メールはありません。<br><br><br>');
		return false;
	}
	$msg_list = $pop3->getListing();
	if ($msg_num > $read_max) {
		$num_limit = $msg_num - $read_max + 1;
	} else {
		$num_limit = 1;
	}
	$mail_list = array();
	for ($ix=$msg_num; $ix>=$num_limit; $ix--) {
		$header_list = $pop3->getParsedHeaders($ix);
		$mail_list['from'][$ix] = mb_decode_mimeheader($header_list['From']);
		$mail_list['to'][$ix] = mb_decode_mimeheader($header_list['To']);
		$mail_list['subject'][$ix] = mb_convert_encoding(mb_decode_mimeheader($header_list['Subject']), "UTF-8", "auto");
		$mail_list['date'][$ix] = strtotime(mb_decode_mimeheader($header_list['Date']));
	}
	$pop3->disconnect();
	session_start();
	for ($ix=$msg_num; $ix>=$num_limit; $ix--) {
		$_SESSION['email_get'][$id_email]['from'][$ix] = $mail_list['from'][$ix];
		$_SESSION['email_get'][$id_email]['to'][$ix] = $mail_list['to'][$ix];
		$_SESSION['email_get'][$id_email]['subject'][$ix] = $mail_list['subject'][$ix];
		$_SESSION['email_get'][$id_email]['date'][$ix] = $mail_list['date'][$ix];
	}
	$_SESSION['email_get'][$id_email]['msg_num'] = $msg_num;
	$_SESSION['email_get'][$id_email]['get'] = true;
	session_write_close();
	return $msg_num;
}
?>
