<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	ob_implicit_flush();	//自動フラッシュをオン(出力をバッファリングしない)
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<title>OneToOneメール送信</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER_COMMON ?>/common.css?20120922">
<link rel="stylesheet" href="<?= _STYLE_SHEET_BUTTON ?>">
<style>
p.header {
	margin: 5px;
}
span.header_data {
	margin-left: 5px;
	padding: 2px 4px;
	border: 1px solid #aaa;
}
</style>
</head>
<body>
<div class="input_form">
<h3>OneToOneメール<a class="a_cancel_back" href='javascript:history.back();'>戻る</a></h3>
<?php
	if (isset($_POST['sendmail']) and $_POST['subject'] <> '' and $_POST['body'] <> '') {
		$params = Array();
		$params['host'] = form_str_adjust($_POST['host']);
		$params['port'] = form_str_adjust($_POST['port']);
		$params['auth'] = form_str_adjust($_POST['auth']);
		$params['username'] = form_str_adjust($_POST['username']);
		$params['password'] = form_str_adjust($_POST['password']);
		$headers = Array();
		$headers['Subject'] = form_str_adjust($_POST['subject']);
		$headers['From'] = form_str_adjust($_POST['from']);
		$headers['To'] = form_str_adjust($_POST['to']);
		$headers['Cc'] = form_str_adjust($_POST['cc']);
		$headers['Bcc'] = form_str_adjust($_POST['bcc']);
		$headers['Reply-To'] = form_str_adjust($_POST['reply_to']);
		$body = form_str_adjust($_POST['body']);
		$mailto = explode(',', form_str_adjust($_POST['mailto']));
		$first = true;
		foreach ($mailto as $to) {
			$to_addr = explode("\t", $to);
			if ($first) {
?>
				<table>
				<tr>
					<td>件名</td>
					<td><?= my_htmlspecialchars($headers['Subject']) ?></td>
				</tr>
				<tr>
					<td>From</td>
					<td><?= my_htmlspecialchars($headers['From']) ?></td>
				</tr>
				<?php	if ($headers['Cc'] <> '') { ?>
				<tr>
					<td>Cc</td>
					<td><?= my_htmlspecialchars($headers['Cc']) ?></td>
				</tr>
				<?php	} ?>
				<?php	if ($headers['Bcc'] <> '') { ?>
				<tr>
					<td>Bcc</td>
					<td><?= my_htmlspecialchars($headers['Bcc']) ?></td>
				</tr>
				<?php	} ?>
				<?php	if ($headers['Reply-To'] <> '') { ?>
				<tr>
					<td>Reply-To</td>
					<td><?= my_htmlspecialchars($headers['Reply-To']) ?></td>
				</tr>
				<?php	} ?>
				<tr>
					<td></td>
					<td>↓ 本文赤字部分の宛先名は、1件ずつ置き換えて送信されます。</td>
				</tr>
				<tr>
					<td>本文</td>
					<td>
					<?= str_replace("\n", '<br>', str_replace('@@ TO @@', '<span style="color:red;">'.$to_addr[1].'</span>', my_htmlspecialchars($body))) ?>
					</td>
				</tr>
				<table>
				<br>
<?php
			}
			post_sendmail($params, $to_addr[0], $to_addr[1], $headers, $body);
			$first = false;
		}
	}
?>
<div id="footer" style="margin: 10px 0 0 0;">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function post_sendmail($params, $to_addr, $to_name, $headers, $body) {
	$body = str_replace('@@ TO @@', $to_name, $body);
	$headers['To'] = $to_addr;
	$ret = my_send_mail2($params, $to_addr, $headers, $body);
	if ($ret) {
		echo '<p>'.my_htmlspecialchars($to_name).'&lt;'.$to_addr.'&gt;さん宛てメール送信しました。</p>';
	} else {
		error_exit('<p>メール送信でエラーが発生しました。</p>');
	}
}
?>
